/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRBufferPoolName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "93165E79-636D-32BB-72EF-744709C7F968";

    public DRBufferPoolName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRBufferPoolName.CheckBufferpoolNameIsValid"));
        this.setDescription(Messages.getString("DRBufferPoolName.BufferpoolNameShouldBeValid"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        BufferPoolUDB bufferPoolUDB = (BufferPoolUDB)object;
        if (bufferPoolUDB.getName().toUpperCase().startsWith("IBM") && bufferPoolUDB.getName().equalsIgnoreCase("IBMDEFAULTGROUP") && bufferPoolUDB.getName().equalsIgnoreCase("IBMTEMPGROUP")) {
            return CheckResult.createWarning(bufferPoolUDB, this, Messages.getString("DRBufferPoolName.BufferpoolNameStartsWithIBM"));
        }
        if (bufferPoolUDB.getName().toUpperCase().startsWith("SYS")) {
            return CheckResult.createWarning(bufferPoolUDB, this, Messages.getString("DRBufferPoolName.BufferpoolNameStartsWithSYS"));
        }
        if (bufferPoolUDB.getName().toUpperCase().startsWith("DBM")) {
            return CheckResult.createWarning(bufferPoolUDB, this, Messages.getString("DRBufferPoolName.BufferpoolNameStartsWithDBM"));
        }
        if (bufferPoolUDB.getName().indexOf(32) > -1) {
            return CheckResult.createWarning(bufferPoolUDB, this, Messages.getString("DRBufferPoolName.BufferpoolNameContainsBlank"));
        }
        return CheckResult.createOk(bufferPoolUDB, this, Messages.getString("DRBufferPoolName.BufferpoolNameValid"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "93165E79-636D-32BB-72EF-744709C7F968";
    }
}

