/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRAliasAnotherAlias
extends AbstractDRStorageDesign {
    private final String RULE_ID = "21E5DBA5-FDCC-DC65-FE01-FBE275200E97";

    public DRAliasAnotherAlias(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRAliasAnotherAlias.CheckTheReferencedObject"));
        this.setDescription(Messages.getString("DRAliasAnotherAlias.NameShouldBeDifferentFromTheNameOfAlias"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        AliasUDB aliasUDB = (AliasUDB)object;
        if (aliasUDB.getReferencedObject() instanceof AliasUDB) {
            AliasUDB aliasUDB2 = (AliasUDB)aliasUDB.getReferencedObject();
            if (aliasUDB2.getName().equals(aliasUDB.getName())) {
                return CheckResult.createFailed(object, this, Messages.getString("DRAliasAnotherAlias.AliasAndAnotherAliasHaveSameName"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRAliasAnotherAlias.AliasAndAnotherAliasHaveDifferentNames"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRAliasAnotherAlias.ReferencedObjectIsNotAnotherAlias"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "21E5DBA5-FDCC-DC65-FE01-FBE275200E97";
    }
}

