/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyTextImageOn
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1D6D68DA-800B-601A-C7AD-8306598D5C8B";
    public static final String TEXT = "TEXT";
    public static final String NTEXT = "NTEXT";
    public static final String IMAGE = "IMAGE";

    public DRTableProxyTextImageOn(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyTextImageOn.CheckUseOfTEXTIMAGEON"));
        this.setDescription(Messages.getString("DRTableProxyTextImageOn.CannotUseTEXTIMAGEON"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)object;
        if (tableProxySqlServer.getTextImageFG() != null) {
            ColumnProxy[] columnProxyArray = tableProxySqlServer.getColumnProxies();
            String string = "";
            boolean bl = false;
            for (int i = 0; i < columnProxyArray.length; ++i) {
                string = columnProxyArray[i].getDataType().getName();
                if (!TEXT.equalsIgnoreCase(string) && !NTEXT.equalsIgnoreCase(string) && !IMAGE.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                return CheckResult.createOk(object, this, Messages.getString("DRTableProxyTextImageOn.TEXTIMAGEONUsedCorrectly"));
            }
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyTextImageOn.CannotUseTEXTIMAGEON"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyTextImageOn.ThisTableDoNotHaveTEXTIMAGEONSpecified"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "1D6D68DA-800B-601A-C7AD-8306598D5C8B";
    }
}

