/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyMaxForeignKeys
extends AbstractDRStorageDesign {
    private final String RULE_ID = "D7DE09A0-F1D1-5974-60AB-451FF4A9DC62";

    public DRTableProxyMaxForeignKeys(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyMaxForeignKeys.CheckCountFK"));
        this.setDescription(Messages.getString("DRTableProxyMaxForeignKeys.TableCanContainMax253FK"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)object;
        Table table = (Table)tableProxySqlServer.getObject();
        if (table.getFKAssociations().length > 253) {
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyMaxForeignKeys.TableHasMoreThan253FK"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyMaxForeignKeys.TheCountFKIsValid"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "D7DE09A0-F1D1-5974-60AB-451FF4A9DC62";
    }
}

