/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ReservedWordsSqlServerv2k;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRReservedWordName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "587DAE61-0740-4364-35EA-3FAD9F92BCBA";
    private ReservedWordsSqlServerv2k reserved = new ReservedWordsSqlServerv2k();
    private StorageDesignSqlServer stoDesign = null;

    public DRReservedWordName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRReservedWordName.IdentifyObjectsUsingReservedWords"));
        this.setDescription(Messages.getString("DRReservedWordName.ObjectIdentifierSshouldNotBeReservedWord"));
        this.stoDesign = (StorageDesignSqlServer)storageDesign;
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.stoDesign.updateGeneralRule();
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String string = modelIDObject.getName();
        if (this.reserved.isReservedWord(string)) {
            return CheckResult.createWarning(modelIDObject, this, MessageFormat.format(Messages.getString("DRReservedWordName.TheNameIisReservedWord"), string));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRReservedWordName.TheNameIsNotReservedWord"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "587DAE61-0740-4364-35EA-3FAD9F92BCBA";
    }
}

