/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRDesignObjectMaxNameLength;

public class DRDatabaseMaxNameLength
extends DRDesignObjectMaxNameLength {
    private final String RULE_ID = "2F6ADAB5-5650-9565-7F2B-729A62F2E61D";

    public DRDatabaseMaxNameLength(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)object;
        String string = dataBaseSqlServer.getName();
        if (string.length() > 0) {
            if (string.length() > 128) {
                return CheckResult.createFailed(dataBaseSqlServer, this, new StringBuffer(Messages.getString("DRDatabaseMaxNameLength.NameHasMoreThan128Characters")).toString());
            }
            if (!Character.isLetter(string.charAt(0))) {
                return CheckResult.createFailed(dataBaseSqlServer, this, Messages.getString("DRDatabaseMaxNameLength.FirstCharacterMustBeLetter"));
            }
            return CheckResult.createOk(dataBaseSqlServer, this, Messages.getString("DRDatabaseMaxNameLength.DatabaseNameValid"));
        }
        return CheckResult.createFailed(dataBaseSqlServer, this, Messages.getString("DRDatabaseMaxNameLength.NoNameSpecified"));
    }

    @Override
    public String getRuleId() {
        return "2F6ADAB5-5650-9565-7F2B-729A62F2E61D";
    }
}

