/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRConstraintNameSqlServer
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C584BEDF-B352-BE31-A267-9E8EF38AF85E";

    public DRConstraintNameSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRConstraintNameSqlServer.CheckConstraintNames"));
        this.setDescription(Messages.getString("DRConstraintNameSqlServer.ConstraintsShouldHaveUN"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        StorageDesignSqlServer storageDesignSqlServer = (StorageDesignSqlServer)object;
        if (storageDesignSqlServer.getPKProxySet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameSqlServer.DublicatePKNames"));
        }
        if (storageDesignSqlServer.getUniqueProxySet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameSqlServer.DublicateUKNames"));
        }
        if (storageDesignSqlServer.getFKProxySet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameSqlServer.DublicateFKNames"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRConstraintNameSqlServer.ConstraintsHaveUN"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "C584BEDF-B352-BE31-A267-9E8EF38AF85E";
    }
}

