/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRColumnFormulaEmpty
extends AbstractDRStorageDesign {
    private final String RULE_ID = "F44608A5-4AD3-DB90-5FE8-97ACA491AA52";

    public DRColumnFormulaEmpty(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRColumnFormulaEmpty.CheckForEmptyFormula"));
        this.setDescription(Messages.getString("DRColumnFormulaEmpty.ForComputedColumnsFormulaShouldNotBeEmpty"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)object;
        if (columnProxySqlServer.getComputed()) {
            if ("".equalsIgnoreCase(columnProxySqlServer.getFormula())) {
                return CheckResult.createFailed(object, this, Messages.getString("DRColumnFormulaEmpty.FormulaEmpty"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRColumnFormulaEmpty.FormulaNotEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRColumnFormulaEmpty.ColumnNotComputed"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "F44608A5-4AD3-DB90-5FE8-97ACA491AA52";
    }
}

