/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionListMaxColumnsOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "68A56EB7-A613-37CA-C338-ADFD40908BA9";

    public DRPartitionListMaxColumnsOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionListMaxColumnsOracle.SetPartitionListColumns"));
        this.setDescription(Messages.getString("DRPartitionListMaxColumnsOracle.NumberOfColumnsMustBeEqualLessThan16"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        PartitionListOracle partitionListOracle = (PartitionListOracle)object;
        StringTokenizer stringTokenizer = new StringTokenizer(partitionListOracle.getColumnList(), ",");
        int n = stringTokenizer.countTokens();
        if (n > 16) {
            return CheckResult.createFailed(object, this, Messages.getString("DRPartitionListMaxColumnsOracle.PartitionListContainsMoreThan16Columns"));
        }
        return CheckResult.createOk(object, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "68A56EB7-A613-37CA-C338-ADFD40908BA9";
    }
}

