/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterMaxColumnsOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C49D8DFA-270F-52C1-229F-85C13586DD21";

    public DRClusterMaxColumnsOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterMaxColumnsOracle.IdentifyClustersWithTooManyColumns"));
        this.setDescription(Messages.getString("DRClusterMaxColumnsOracle.ClustersAbove16SolumnsNotAllowed"));
    }

    private int getClusterColumns(ClusterOracle clusterOracle) {
        ClusterColumnSetOracle clusterColumnSetOracle = ((StorageDesignOracle)clusterOracle.getStorageDesign()).getClusterColumnSet();
        Iterator iterator = clusterColumnSetOracle.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)iterator.next();
            if (clusterColumnOracle.getCluster() == null || !clusterColumnOracle.getCluster().equals(clusterOracle)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle clusterOracle = (ClusterOracle)object;
        int n = this.getClusterColumns(clusterOracle);
        if (n > 16) {
            return CheckResult.createFailed(object, this, new StringBuffer(Messages.getString("DRClusterMaxColumnsOracle.Only16CcolumnsAllowed")).append(n).append('.').toString());
        }
        if (n == 16) {
            return CheckResult.createOk(object, this, Messages.getString("DRClusterMaxColumnsOracle.MaximumNumberOfColumnsReached"));
        }
        return CheckResult.createOk(object, this, new StringBuffer(Messages.getString("DRClusterMaxColumnsOracle.MaximumNumberCcolumnsNotReached")).append(n).append('.').toString());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "C49D8DFA-270F-52C1-229F-85C13586DD21";
    }
}

