/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterHashKeysOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "40147E80-B9FD-0136-6E0A-DF8D585CB183";

    public DRClusterHashKeysOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterHashKeysOracle.SetClusterHashKeys"));
        this.setDescription(Messages.getString("DRClusterHashKeysOracle.IndexedClusterCanNotBehashcluster"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle clusterOracle = (ClusterOracle)object;
        if ("Yes".equalsIgnoreCase(clusterOracle.getIndexed()) && clusterOracle.getHashKeys() >= 2) {
            return CheckResult.createWarning(object, this, this.getDescription());
        }
        if ("No".equalsIgnoreCase(clusterOracle.getIndexed()) && clusterOracle.getHashKeys() >= 2) {
            return CheckResult.createOk(object, this, Messages.getString("DRClusterHashKeysOracle.ClusterNotIndexed"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRClusterHashKeysOracle.ClusterNotHashCluster"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "40147E80-B9FD-0136-6E0A-DF8D585CB183";
    }
}

