/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterColumnDataTypeOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "CEF078FC-87DB-5EB3-D91D-09542D2B16F2";
    private static final String[] DATA_TYPE = new String[]{"INTEGER", "NUMBER"};
    private static Set dataTypeSet = null;

    public DRClusterColumnDataTypeOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterColumnDataTypeOracle.SetHashClusterColumnsDataType"));
        this.setDescription(Messages.getString("DRClusterColumnDataTypeOracle.HashClusterCannotBeDefined"));
    }

    public static String[] getDataTypes() {
        return DATA_TYPE;
    }

    private boolean checkDataType(String string) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(DRClusterColumnDataTypeOracle.getDataTypes()));
        }
        return dataTypeSet.contains(string);
    }

    private boolean checkClusterColumns(StringBuffer stringBuffer, ClusterOracle clusterOracle) {
        ClusterColumnSetOracle clusterColumnSetOracle = ((StorageDesignOracle)clusterOracle.getStorageDesign()).getClusterColumnSet();
        Iterator iterator = clusterColumnSetOracle.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)iterator.next();
            if (clusterColumnOracle.getCluster() == null || !clusterColumnOracle.getCluster().equals(clusterOracle)) continue;
            if (!this.checkDataType(clusterColumnOracle.getDataType())) {
                ++n;
                stringBuffer.append(clusterColumnOracle.getName()).append(':').append(clusterColumnOracle.getDataType()).append(' ');
                continue;
            }
            if (!"NUMBER".equalsIgnoreCase(clusterColumnOracle.getDataType()) || "".equalsIgnoreCase(clusterColumnOracle.getLengthPrecision()) || "0".equalsIgnoreCase(clusterColumnOracle.getLengthPrecision())) continue;
            ++n;
            stringBuffer.append(clusterColumnOracle.getName()).append(':').append(clusterColumnOracle.getLengthPrecision()).append(' ');
        }
        return n <= 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle clusterOracle = (ClusterOracle)object;
        StringBuffer stringBuffer = new StringBuffer();
        if ("No".equalsIgnoreCase(clusterOracle.getIndexed()) && clusterOracle.getHashKeys() >= 2) {
            if (!this.checkClusterColumns(stringBuffer, clusterOracle)) {
                return CheckResult.createFailed(object, this, new StringBuffer(Messages.getString("DRClusterColumnDataTypeOracle.ClusterHasColumnsWithWrongDatatype")).append("(").append(stringBuffer).append(").").toString());
            }
            return CheckResult.createOk(object, this, this.getDescription());
        }
        return CheckResult.createOk(object, this, Messages.getString("DRClusterColumnDataTypeOracle.ClusterNotHashCluster"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "CEF078FC-87DB-5EB3-D91D-09542D2B16F2";
    }
}

