/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v80;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionTablespaceWithoutPartTable
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C9A2A02C-FAD2-81B3-D9B5-373E82A39950";

    public DRPartitionTablespaceWithoutPartTable(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionTablespaceWithoutPartTable.CheckForPartitionedTablespaces"));
        this.setDescription(Messages.getString("DRPartitionTablespaceWithoutPartTable.PartitionedTablespacesShouldHavePartitioningTable"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceDB2v80 tableSpaceDB2v80 = (TableSpaceDB2v80)object;
        if ("PARTITIONED".equalsIgnoreCase(tableSpaceDB2v80.getType())) {
            if (tableSpaceDB2v80.getPartTable() == null) {
                return CheckResult.createFailed(tableSpaceDB2v80, this, Messages.getString("DRPartitionTablespaceWithoutPartTable.PartitionedtablespaceDoesNotHavePartitioningTable"));
            }
            return CheckResult.createOk(tableSpaceDB2v80, this, Messages.getString("DRPartitionTablespaceWithoutPartTable.PartitionedTablespaceHasPartitioningTable"));
        }
        return CheckResult.createOk(tableSpaceDB2v80, this, Messages.getString("DRPartitionTablespaceWithoutPartTable.CurrentTablespaceIsNotPartitioned"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "C9A2A02C-FAD2-81B3-D9B5-373E82A39950";
    }
}

