/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyFKNoGenerate
extends AbstractDRStorageDesign {
    private final String RULE_ID = "A1CAAC8C-A0ED-236B-C568-5F8B133E9577";

    public DRTableProxyFKNoGenerate(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyFKNoGenerate.IdentifyFKWhichAreNotMarkedGenerate"));
        this.setDescription(Messages.getString("DRTableProxyFKNoGenerate.GenerateDDLFForThisForeignKey"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = true;
        FKIndexAssociation[] fKIndexAssociationArray = table.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            ContainerObject containerObject = fKIndexAssociationArray[i].getOriginalContainer();
            RelationalObjectProxy relationalObjectProxy = this.getProxyFor(containerObject);
            if (relationalObjectProxy == null) {
                stringBuffer.append(MessageFormat.format(containerObject.getName(), Messages.getString("DRTableProxyFKNoGenerate.NotFoundInStorageDesign")));
                bl = false;
                continue;
            }
            if (relationalObjectProxy.isMarkedGenerate()) continue;
            stringBuffer.append(MessageFormat.format(containerObject.getName(), Messages.getString("DRTableProxyFKNoGenerate.NotMarkedGenerate")));
            bl = false;
        }
        if (bl) {
            stringBuffer2.append(Messages.getString("DRTableProxyFKNoGenerate.AllFKMarkedGenerate"));
            return CheckResult.createOk(object, this, stringBuffer2.toString());
        }
        stringBuffer2.append(Messages.getString("DRTableProxyFKNoGenerate.NotAllForeignKeysAreMarkedGenerate")).append(stringBuffer);
        return CheckResult.createWarning(object, this, stringBuffer2.toString());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "A1CAAC8C-A0ED-236B-C568-5F8B133E9577";
    }
}

