/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.ReservedWordsDB2v70;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRReservedWordName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "6A6DD330-3C41-7BA8-03C8-669B821AA909";
    private ReservedWordsDB2v70 reserved = new ReservedWordsDB2v70();
    private AbstractStorageDesignDB2 stoDesign = null;

    public DRReservedWordName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRReservedWordName.IdentifyObjectsUseReservedWordsInTheirName"));
        this.setDescription(Messages.getString("DRReservedWordName.ObjectMayNotHaveAnIdentifierThatIsReservedWord"));
        this.stoDesign = (AbstractStorageDesignDB2)storageDesign;
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.stoDesign.updateGeneralRule();
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String string = modelIDObject.getName();
        if (this.reserved.isReservedWord(string)) {
            return CheckResult.createWarning(modelIDObject, this, MessageFormat.format(Messages.getString("DRReservedWordName.TheNameIsAReservedWord"), string));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRReservedWordName.TheNameIsNotReservedWord"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "6A6DD330-3C41-7BA8-03C8-669B821AA909";
    }
}

