/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRLOBColumnInIndex
extends AbstractDRStorageDesign {
    private final String RULE_ID = "BE4FCA49-89D3-DABC-75ED-3B1976DB43D4";
    public static final String CLOB = "CLOB";
    public static final String BLOB = "BLOB";
    public static final String DBCLOB = "DBCLOB";

    public DRLOBColumnInIndex(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRLOBColumnInIndex.CheckForLOBColumnIndex"));
        this.setDescription(Messages.getString("DRLOBColumnInIndex.IndexShouldNotContainLOBcolumn"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)object;
        ColumnProxy[] columnProxyArray = indexProxyDB2.getColumnProxies();
        String string = "";
        for (int i = 0; i < columnProxyArray.length; ++i) {
            string = columnProxyArray[i].getDataType().getName();
            if (!CLOB.equalsIgnoreCase(string) && !BLOB.equalsIgnoreCase(string) && !DBCLOB.equalsIgnoreCase(string)) continue;
            return CheckResult.createFailed(object, this, Messages.getString("DRLOBColumnInIndex.IndexContainsLOBColumn"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRLOBColumnInIndex.IndexDoesNotContainLOBColumn"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "BE4FCA49-89D3-DABC-75ED-3B1976DB43D4";
    }
}

