/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTableMaxColumns
extends DesignRule {
    private final String RULE_ID = "CF0A125C-7E89-7621-B9E5-90448C54FC4C";
    private int maxColumns = 0;

    public DRTableMaxColumns() {
        this(750);
    }

    public DRTableMaxColumns(int n) {
        this.setMaxColumns(n);
        this.setName(Messages.getString("DRTableMaxColumns.IdentifyTablesWithTooManyColumns"));
        this.setDescription(MessageFormat.format(Messages.getString("DRTableMaxColumns.TablesAboveColumnsNotAllowed"), this.getMaxColumns()));
    }

    public void setMaxColumns(int n) {
        this.maxColumns = n;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Table table = (Table)object;
        if (table.size() > this.getMaxColumns()) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRTableMaxColumns.CheckColumns"), this.getMaxColumns(), table.size(), this.getContextString()));
        }
        return CheckResult.createOk(object, this, MessageFormat.format(Messages.getString("DRTableMaxColumns.MaximumNumberOfColumns"), this.getMaxColumns(), table.size()));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "CF0A125C-7E89-7621-B9E5-90448C54FC4C";
    }
}

