/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;

public class DRForeignKeyNamingStandard
extends DesignRule {
    private final String RULE_ID = "040912D7-30F2-90FE-BDF0-B82D20A0240B";
    private String parentName = "";
    private String childName = "";

    public DRForeignKeyNamingStandard() {
        this.setName(Messages.getString("DRForeignKeyNamingStandard.IdentifyFKWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRForeignKeyNamingStandard.FKWithWrongNamingStandardsAreNotRecommended"));
    }

    private int getPosition(Index index) {
        FKIndexAssociation[] fKIndexAssociationArray = index.getTable().getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            if (!index.getFKAssociation().equals(fKIndexAssociation)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.isFK()) {
            FKIndexAssociation fKIndexAssociation = index.getFKAssociation();
            DesignObject designObject = fKIndexAssociation.getSourceObject();
            this.parentName = designObject == null ? "" : designObject.getName();
            this.parentName = this.parentName.replaceAll("\\$", "\\\\\\$");
            this.childName = fKIndexAssociation.getTargetObject().getName();
            this.childName = this.childName.replaceAll("\\$", "\\\\\\$");
            if (fKIndexAssociation.getName().equalsIgnoreCase(FKUtilities.generateFKName(fKIndexAssociation, this.getPosition(index)))) {
                return CheckResult.createOk(index, this, Messages.getString("DRForeignKeyNamingStandard.FKNameIsInValidFormat"));
            }
            return CheckResult.createWarning(index, this, this.getDescription());
        }
        return CheckResult.createOk(index, this, Messages.getString("DRForeignKeyNamingStandard.FKNameIsInValidFormat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "040912D7-30F2-90FE-BDF0-B82D20A0240B";
    }
}

