/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRColumnNamingStandard
extends DesignRule {
    private final String RULE_ID = "F65408E2-1E0A-088D-97FC-CC1840290370";
    private NamingStandardRule namingRule;

    public DRColumnNamingStandard() {
        this.setName(Messages.getString("DRColumnNamingStandard.IdentifyColumnsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRColumnNamingStandard.ColumnsWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        char c;
        Column column = (Column)object;
        this.namingRule = column.getDesign().getDLSettings().getNamingStandardRule();
        Iterator iterator = this.namingRule.getGlossaries().iterator();
        String string = "";
        NamingOptionsHolder namingOptionsHolder = column.getDesignPart().getNamingOptionsHolderFor(Column.class);
        if (namingOptionsHolder == null) {
            namingOptionsHolder = column.getDesignPart().getNamingOptionsHolderFor(Column.class);
        }
        boolean bl = false;
        if (namingOptionsHolder != null && (c = namingOptionsHolder.getCaseType()) == '\u0000') {
            bl = true;
        }
        c = this.namingRule.getRelationalSeparatorChar();
        boolean bl2 = this.namingRule.isAbbreviatedOnly();
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(column.getName(), this.namingRule.getColumnsList(), c, false, bl, true, bl2);
            if (string2 == null) {
                return CheckResult.createOk(column, this, Messages.getString("DRColumnNamingStandard.ColumnNmeIsInValidFormat"));
            }
            if (string.length() == 0) {
                string = string2;
                continue;
            }
            string = string + ". " + string2;
        }
        if ("".equals(string)) {
            return CheckResult.createOk(column, this, Messages.getString("DRColumnNamingStandard.ColumnNameIsInValidFormat"));
        }
        return CheckResult.createWarning(column, this, string);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "F65408E2-1E0A-088D-97FC-CC1840290370";
    }
}

