/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRColumnCircularRef
extends DesignRule {
    private final String RULE_ID = "BB3763EB-43B2-4C1C-60DB-A68592F83F74";
    private Column testedColumn;
    private Column lastChecked;
    List checkedCols;

    public DRColumnCircularRef() {
        this.setName(Messages.getString("DRColumnCircularRef.IdentifyCircularReferingColumns"));
        this.setDescription(Messages.getString("DRColumnCircularRef.ClumnCircularReferenceIsNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.testedColumn = (Column)object;
        boolean bl = this.hasCircularRef();
        if (bl) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRColumnCircularRef.ColumnsHaveCircularreference"), this.testedColumn.getLongName(), this.lastChecked.getLongName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRColumnCircularRef.ColumnDoesntHaveCircularReferences"));
    }

    @Override
    public int getType() {
        return 0;
    }

    private boolean hasCircularRef() {
        this.checkedCols = new ArrayList();
        if (this.testedColumn.isFKColumn()) {
            for (Column.FKColRefNode fKColRefNode : this.testedColumn.getRefColAndAssocIDs()) {
                Column column = (Column)this.testedColumn.getDesign().getDesignObject(fKColRefNode.refColumnId);
                if (column == null) continue;
                this.lastChecked = column;
                if (this.testedColumn == column) {
                    return true;
                }
                if (this.checkedCols.contains(column)) continue;
                this.checkedCols.add(column);
                boolean bl = this.testColumn(column);
                if (!bl) continue;
                return bl;
            }
        }
        return false;
    }

    private boolean testColumn(Column column) {
        if (column.isFKColumn()) {
            for (Column.FKColRefNode fKColRefNode : column.getRefColAndAssocIDs()) {
                Column column2 = (Column)this.testedColumn.getDesign().getDesignObject(fKColRefNode.refColumnId);
                if (column2 == null) continue;
                if (this.testedColumn == column2) {
                    return true;
                }
                if (this.checkedCols.contains(column2)) continue;
                this.checkedCols.add(column2);
                boolean bl = this.testColumn(column2);
                if (!bl) continue;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String getRuleId() {
        return "BB3763EB-43B2-4C1C-60DB-A68592F83F74";
    }
}

