/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRColumnCheckDefaultAndPermittedValue
extends DesignRule {
    private final String RULE_ID = "85E54E09-B62E-69A9-EDFC-437D176EADCE";
    Column column;
    String beginValue;
    String endValue;
    double doubleValue = 0.0;
    boolean result = false;
    Double d = null;

    public DRColumnCheckDefaultAndPermittedValue() {
        this.setName(Messages.getString("DRColumnCheckDefaultAndPermittedValue.CheckForColumnDefaultValuesCompiledWithPermittedValues"));
        this.setDescription(Messages.getString("DRColumnCheckDefaultAndPermittedValue.ColumnDefaultValuesWithoutPermittedValuesAreNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.column = (Column)object;
        String string = this.column.getDefaultValue();
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        try {
            this.doubleValue = Double.parseDouble(string);
            this.d = new Double(this.doubleValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.d = null;
        }
        if (!"".equals(string)) {
            this.result = this.checkValue(string);
            if (!this.result) {
                return CheckResult.createFailed(this.column, this, Messages.getString("DRColumnCheckDefaultAndPermittedValue.DefaultVlueViolatedPermittedValues"));
            }
        }
        return CheckResult.createOk(this.column, this, Messages.getString("DRColumnCheckDefaultAndPermittedValue.ColumnDefaultValueIsPermitted"));
    }

    public boolean checkValue(String string) {
        Object object;
        Iterator iterator;
        if ("".equals(string)) {
            return true;
        }
        boolean bl = true;
        if (!this.column.getAVTs().isEmpty()) {
            iterator = this.column.getAVTs().iterator();
            while (iterator.hasNext()) {
                bl = false;
                object = (AVT)iterator.next();
                this.beginValue = ((AVT)object).getBeginValue();
                if (this.beginValue.startsWith("'")) {
                    this.beginValue = this.beginValue.substring(1, this.beginValue.length() - 1);
                }
                this.endValue = ((AVT)object).getEndValue();
                if (this.endValue.startsWith("'")) {
                    this.endValue = this.endValue.substring(1, this.endValue.length() - 1);
                }
                if (this.d == null) {
                    if (!(!"".equals(this.endValue) ? string.compareTo(this.beginValue) >= 0 && string.compareTo(this.endValue) <= 0 : string.equals(this.beginValue))) continue;
                    return true;
                }
                boolean bl2 = true;
                double d = 0.0;
                double d2 = 0.0;
                try {
                    d = Double.parseDouble(this.beginValue);
                    d2 = Double.parseDouble(this.endValue);
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
                try {
                    if (!(!"".equals(this.endValue) ? (bl2 ? this.doubleValue >= d && this.doubleValue <= d2 : string.compareTo(this.beginValue) >= 0 && string.compareTo(this.endValue) <= 0) : (bl2 ? this.doubleValue == d : string.equals(this.beginValue)))) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        if (this.column.getValueList() != null) {
            iterator = this.column.getValueList().values();
            while (iterator.hasNext()) {
                bl = false;
                object = (String)iterator.next();
                if (((String)object).startsWith("'")) {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                }
                if (this.d == null) {
                    if (!string.equals(object)) continue;
                    return true;
                }
                try {
                    if (this.doubleValue != Double.parseDouble((String)object)) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return bl;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "85E54E09-B62E-69A9-EDFC-437D176EADCE";
    }
}

