/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRUseTrTaskProcessWithoutInputParamsMapping
extends DesignRule {
    private final String RULE_ID = "863D1EC6-95C5-A5D8-5E9A-BBFF316F0608";

    public DRUseTrTaskProcessWithoutInputParamsMapping() {
        this.setName(Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.IdentifyUseTransformationTaskProcessesWithoutInputParametersMapping"));
        this.setDescription(Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.UseTransformationTaskProcessesShouldHaveInputParametersMapping"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        if (process.getType() == 2) {
            if (process.getTransformationTask() != null) {
                List list = process.getTransformationTask().getInputParameters();
                if (list.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = true;
                    for (int i = 0; i < list.size(); ++i) {
                        ParameterObject parameterObject = (ParameterObject)list.get(i);
                        if (process.getParamMapping(parameterObject) != null) continue;
                        if (!bl) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(parameterObject.getName());
                        bl = false;
                    }
                    if (stringBuffer.length() > 0) {
                        return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.Parameters"), stringBuffer.toString()));
                    }
                    return CheckResult.createOk(object, this, Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.AllInTheProcessParametersHaveMapping"));
                }
                return CheckResult.createOk(object, this, Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.TransformationTaskDoesntHaveInputParameters"));
            }
            return CheckResult.createWarning(object, this, Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.ProcessIsOfTypeUseTransformationTaskNoTransformationTaskAttached"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRUseTrTaskProcessWithoutInputParamsMapping.ProcessNotOfTypeUseTransformationTask"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "863D1EC6-95C5-A5D8-5E9A-BBFF316F0608";
    }
}

