/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTransformationWithoutOutgoingFlows
extends DesignRule {
    private final String RULE_ID = "36E068C0-6271-6ABB-9A43-B21C5623A62F";

    public DRTransformationWithoutOutgoingFlows() {
        this.setName(Messages.getString("DRTransformationWithoutOutgoingFlows.IdentifyTransformationsWithoutOutgoingFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DRTransformationWithoutOutgoingFlows.TransformationsShouldHaveOutgoingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Transformation transformation = (Transformation)object;
        if (transformation.getOutgoingFlows().size() == 0) {
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRTransformationWithoutOutgoingFlows.TransformationDoesNotHaveOF"), transformation.getDesignPart().getName()));
        }
        return CheckResult.createOk(object, this, MessageFormat.format(Messages.getString("DRTransformationWithoutOutgoingFlows.TransformationHasOF"), transformation.getDesignPart().getName()));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "36E068C0-6271-6ABB-9A43-B21C5623A62F";
    }
}

