/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRTransformationWithoutIncomingFlows
extends DesignRule {
    private final String RULE_ID = "E06F1277-7137-F903-CED5-630F7411E0C5";

    public DRTransformationWithoutIncomingFlows() {
        this.setName(Messages.getString("DRTransformationWithoutIncomingFlows.IdentifyTransformationsWithoutIncomingFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DRTransformationWithoutIncomingFlows.TransformationsShouldHaveIncomingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Transformation transformation = (Transformation)object;
        if (transformation.getIncomingFlows().size() == 0) {
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRTransformationWithoutIncomingFlows.TransformationDoesntHaveIF"), transformation.getDesignPart().getName()));
        }
        return CheckResult.createOk(object, this, MessageFormat.format(Messages.getString("DRTransformationWithoutIncomingFlows.TransformationHasIF"), transformation.getDesignPart().getName()));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "E06F1277-7137-F903-CED5-630F7411E0C5";
    }
}

