/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRInputParamsWithoutFlow
extends DesignRule {
    private final String RULE_ID = "9662E3D9-C700-D02C-3084-0EE185FE2D36";

    public DRInputParamsWithoutFlow() {
        this.setName(Messages.getString("DRInputParamsWithoutFlow.IdentifyInputParametersWithoutOutgoingFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DRInputParamsWithoutFlow.InputParametersShouldHaveOutgoingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TransformationTask transformationTask = (TransformationTask)object;
        InOutParams inOutParams = transformationTask.getInputParamsObject();
        if (inOutParams.getParams().size() > 0 && inOutParams.getOutgoingFlows().size() == 0) {
            return CheckResult.createFailed(object, this, Messages.getString("DRInputParamsWithoutFlow.InputParametersDoesntHaveOutgoingFlowsConnectedToThem"));
        }
        if (inOutParams.getParams().size() == 0 && inOutParams.getOutgoingFlows().size() > 0) {
            return CheckResult.createFailed(object, this, Messages.getString("DRInputParamsWithoutFlow.ThereIsOutgoingFlowConnectedToNoneInputParameters"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRInputParamsWithoutFlow.InputParametersHaveOutgoingFlowsConnectedTothem"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "9662E3D9-C700-D02C-3084-0EE185FE2D36";
    }
}

