/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRFlowIsNotBalanced
extends DesignRule {
    private final String RULE_ID = "D576EDBC-FE47-884F-F72A-EAECA40DBD80";

    public DRFlowIsNotBalanced() {
        this.setName(Messages.getString("DRFlowIsNotBalanced.IdentifyFlowsThatIsntBalanced"));
        this.setDescription(Messages.getString("DRFlowIsNotBalanced.FlowToCompositeProcessShouldHaveComponentFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Flow flow = (Flow)object;
        if (!flow.isBalanced()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRFlowIsNotBalanced.FlowDoesntHaveComponentFlows"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRFlowIsNotBalanced.FlowIsBalanced"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "D576EDBC-FE47-884F-F72A-EAECA40DBD80";
    }
}

