/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;

public class DRAgentWithoutDataElements
extends DesignRule {
    private final String RULE_ID = "C785C6F2-EA31-BD0B-DF9A-339BDB4F1D3A";

    public DRAgentWithoutDataElements() {
        this.setName(Messages.getString("DRAgentWithoutDataElements.IdentifyExternalAgentsWithoutFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DRAgentWithoutDataElements.ExternalAgentShouldHaveIncomingAndOutgoingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ExternalAgent externalAgent = (ExternalAgent)object;
        if (externalAgent.getNumberOfFlows() == 0) {
            return CheckResult.createWarning(object, this, Messages.getString("DRAgentWithoutDataElements.AgentDoesntHaveFlowsConnectedToIt"));
        }
        List list = externalAgent.getAllViews();
        for (AbstractDataFlowTV abstractDataFlowTV : list) {
            if (abstractDataFlowTV.isConnected()) continue;
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRAgentWithoutDataElements.AgentDoesntHaveFlowsConnectedToItIn"), abstractDataFlowTV.getDesignPartView().getDesignPart().getName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRAgentWithoutDataElements.AgentHasFlowsConnectedToIt"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "C785C6F2-EA31-BD0B-DF9A-339BDB4F1D3A";
    }
}

