/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRPrimaryIdentifierNamingStandard
extends DesignRule {
    private final String RULE_ID = "C297669B-E4DA-989B-1CF8-E083B05EBC8B";

    public DRPrimaryIdentifierNamingStandard() {
        this.setName(Messages.getString("DRPrimaryIdentifierNamingStandard.IdentifyPIWrongNS"));
        this.setDescription(Messages.getString("DRPrimaryIdentifierNamingStandard.PIWrongNSNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        NamingStandardRule namingStandardRule = entity.getDesign().getDLSettings().getNamingStandardRule();
        String string = entity.getName();
        if (entity.hasPK()) {
            if (entity.getPK().getName().equalsIgnoreCase(ApplyAttributesNamingStandards.createPrimaryIdentifierName(string, namingStandardRule))) {
                return CheckResult.createOk(string, this, Messages.getString("DRPrimaryIdentifierNamingStandard.PINameInValidformat"));
            }
            return CheckResult.createWarning(string, this, this.getDescription());
        }
        return CheckResult.createOk(string, this, Messages.getString("DRPrimaryIdentifierNamingStandard.PINameInValidformat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "C297669B-E4DA-989B-1CF8-E083B05EBC8B";
    }
}

