/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;

public class DREntityNoPrimaryKey
extends DREntity {
    private final String RULE_ID = "81CC8D14-EBB2-E0A6-50C4-C5252CAE6962";

    public DREntityNoPrimaryKey() {
        this.setName(Messages.getString("DREntityNoPrimaryKey.IdentifyEntitiesWithoutPrimaryKey"));
        this.setDescription(Messages.getString("DREntityNoPrimaryKey.EntitiesWithoutPKNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ContainerObject containerObject;
        Entity entity = (Entity)object;
        this.setEntityToCheck(entity);
        Entity entity2 = this.getEntityToCheck();
        Iterator iterator = entity.getKeySet().iterator();
        while (iterator.hasNext()) {
            containerObject = (KeyObject)iterator.next();
            if (!((KeyObject)containerObject).isPK()) continue;
            this.clearEntityToCheck();
            return CheckResult.createOk(entity2, this, Messages.getString("DREntityNoPrimaryKey.EntityHasPrimaryKey"));
        }
        containerObject = entity.getHierarchicalParent();
        if (containerObject != null) {
            return this.doCheck(containerObject);
        }
        this.clearEntityToCheck();
        return CheckResult.createWarning(entity2, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "81CC8D14-EBB2-E0A6-50C4-C5252CAE6962";
    }
}

