/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DREntityNamingStandard
extends DREntity
implements NamingConstants {
    private final String RULE_ID = "5AA0CDCE-C6BD-CC7B-6091-448C8E062A4B";
    private NamingStandardRule namingRule;

    public DREntityNamingStandard() {
        this.setName(Messages.getString("DREntityNamingStandard.IdentifyEntitiesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DREntityNamingStandard.EntitiesWithWrongNamingStandardsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        this.namingRule = entity.getDesign().getDLSettings().getNamingStandardRule();
        Iterator iterator = this.namingRule.getGlossaries().iterator();
        String string = "";
        char c = this.namingRule.getLogicalSeparatorChar();
        boolean bl = "Title Case".equalsIgnoreCase(this.namingRule.getLogicalSep());
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(entity.getName(), this.namingRule.getEntitiesList(), c, bl, false, false, false);
            if (string2 == null) {
                return CheckResult.createOk(entity, this, Messages.getString("DREntityNamingStandard.EntityNameIsInValidFormat"));
            }
            if (string.length() == 0) {
                string = string2;
                continue;
            }
            string = string + ". " + string2;
        }
        if ("".equals(string)) {
            return CheckResult.createOk(entity, this, Messages.getString("DREntityNamingStandard.EntityNameIsInValidFormat"));
        }
        return CheckResult.createWarning(entity, this, string);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "5AA0CDCE-C6BD-CC7B-6091-448C8E062A4B";
    }
}

