/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRObjectMaxNameLength
extends DesignRule {
    private final String RULE_ID = "BB6DAC24-C8CC-AF09-E7BC-744B7A596B7B";
    protected NamingOptionsHolder holder;
    protected String nameLengthOK;
    protected String nameMissing;
    protected String nameTooLong;

    public DRObjectMaxNameLength() {
        this("DRObjectMaxNameLength.IdentifyObjectsWhichExceedMaximumNameLength", "DRObjectMaxNameLength.ObjectNameHasTooManyCharacters");
    }

    public DRObjectMaxNameLength(String string, String string2) {
        this(string, string2, "DRObjectMaxNameLength.TheLengthOfTheNameIsOK", "DRObjectMaxNameLength.NoNameSpecified", "DRObjectMaxNameLength.NameHasMoreThan");
    }

    public DRObjectMaxNameLength(String string, String string2, String string3, String string4, String string5) {
        this.setName(Messages.getString(string));
        this.setDescription(Messages.getString(string2));
        this.nameLengthOK = Messages.getString(string3);
        this.nameMissing = Messages.getString(string4);
        this.nameTooLong = Messages.getString(string5);
    }

    @Override
    public CheckResult doCheck(Object object) {
        return this.doCheck(object, object.getClass());
    }

    public CheckResult doCheck(Object object, Class clazz) {
        return this.doCheck(object, clazz, null);
    }

    public CheckResult doCheck(Object object, Class clazz, String string) {
        String string2;
        DesignObject designObject = (DesignObject)object;
        String string3 = string2 = string != null ? string : designObject.getName();
        if (string2.length() > 0) {
            this.holder = designObject.getDesignPart().getNamingOptionsHolderFor(clazz.getName());
            if (this.holder.getMaxNameLength() > 0 && string2.length() > this.holder.getMaxNameLength()) {
                return CheckResult.createFailed(designObject, string, this, MessageFormat.format(this.nameTooLong, this.holder.getMaxNameLength()));
            }
        } else {
            return CheckResult.createFailed(designObject, string, this, this.nameMissing);
        }
        return CheckResult.createOk(designObject, string, this, this.nameLengthOK);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "BB6DAC24-C8CC-AF09-E7BC-744B7A596B7B";
    }
}

