/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRObjectCaseType
extends DesignRule {
    private final String RULE_ID = "DECDE701-AF7B-7B70-BB46-DFF2A2FB8BCE";
    private NamingOptionsHolder holder;

    public DRObjectCaseType() {
        this.setName(Messages.getString("DRObjectCaseType.IdentifyObjectNamesWithWrongCaseType"));
        this.setDescription(Messages.getString("DRObjectCaseType.ObjectNameCaseTypeIsWrong"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        return this.doCheck(object, object.getClass(), null);
    }

    public CheckResult doCheck(Object object, Class clazz, String string) {
        String string2;
        DesignObject designObject = (DesignObject)object;
        String string3 = string2 = string != null ? string : designObject.getName();
        if (string2.length() > 0) {
            this.holder = designObject.getDesignPart().getNamingOptionsHolderFor(clazz.getName());
            if (this.holder.getCaseType() == 0 && !string2.toUpperCase().equals(string2)) {
                return CheckResult.createWarning(designObject, this, Messages.getString("DRObjectCaseType.NameNotInUpperCase"));
            }
            if (this.holder.getCaseType() == 1 && !string2.toLowerCase().equals(string2)) {
                return CheckResult.createWarning(designObject, this, Messages.getString("DRObjectCaseType.NameNotInLowerCase"));
            }
        } else {
            return CheckResult.createWarning(designObject, this, Messages.getString("DRObjectCaseType.ThereIsNoNameSpecified"));
        }
        return CheckResult.createOk(designObject, this, Messages.getString("DRObjectCaseType.NameOK"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "DECDE701-AF7B-7B70-BB46-DFF2A2FB8BCE";
    }
}

