/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.GUID;

public class DRCustomScript
extends DesignRule {
    protected String name;
    protected String ruleId;
    protected String purpose;
    protected String object;
    protected String engineName;
    protected String script;
    protected String variable;
    protected DRLibrary library;
    protected String function;
    protected String resultType;
    protected ScriptEngineManager scriptEngineManager;
    protected boolean hasEvalError = false;
    protected ScriptEngine engine;
    protected Compilable compilingEngine;
    public CompiledScript compiledScript;
    protected boolean eval = false;

    public DRCustomScript(String string, String string2, String string3) {
        if (string2 == null || string2.trim().length() == 0) {
            string2 = new GUID().toString();
        }
        this.name = string;
        this.ruleId = string2;
        this.purpose = string3;
        this.setDescription(this.getName());
    }

    public DRCustomScript(String string, String string2, String string3, String string4, String string5, String string6, String string7, ScriptEngineManager scriptEngineManager, DRLibrary dRLibrary, String string8) {
        this(string, string2, string3);
        this.object = string4;
        this.engineName = string5;
        this.script = string6;
        this.variable = string7;
        this.scriptEngineManager = scriptEngineManager;
        this.library = dRLibrary;
        this.function = string8;
    }

    @Override
    public void init() {
        this.hasEvalError = false;
        this.eval = false;
        this.compiledScript = null;
        this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
    }

    @Override
    public CheckResult doCheck(Object object) {
        block13: {
            try {
                if (this.engine == null) {
                    this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
                }
                this.engine.put(this.getVariable(), object);
                if (this.getLibrary() == null) {
                    if (this.engine instanceof Compilable) {
                        if (this.compiledScript == null) {
                            this.compilingEngine = (Compilable)((Object)this.engine);
                            this.compiledScript = this.compilingEngine.compile(this.getScript());
                        }
                        this.compiledScript.eval();
                    } else {
                        this.engine.eval(this.getScript());
                    }
                    break block13;
                }
                if (this.engine instanceof Compilable) {
                    if (this.compiledScript == null) {
                        this.compilingEngine = (Compilable)((Object)this.engine);
                        this.compiledScript = this.compilingEngine.compile(this.getLibrary().getScript());
                    }
                    if (this.engine instanceof Invocable) {
                        if (!this.eval) {
                            this.engine.eval(this.getLibrary().getScript());
                            this.eval = true;
                        }
                        Invocable invocable = (Invocable)((Object)this.engine);
                        invocable.invokeFunction(this.getFunction(), object);
                        break block13;
                    }
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                    this.hasEvalError = true;
                    return null;
                }
                if (this.engine instanceof Invocable) {
                    this.engine.eval(this.getLibrary().getScript());
                    Invocable invocable = (Invocable)((Object)this.engine);
                    invocable.invokeFunction(this.getFunction(), object);
                    break block13;
                }
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (ScriptException scriptException) {
                JOptionPane.showMessageDialog(null, Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + this.getName() + "\n\nLine        : " + scriptException.getLineNumber() + "\nColumn   : " + scriptException.getColumnNumber() + "\nMessage : " + scriptException.getMessage(), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.NoSuchMethod"), this.getFunction()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
        }
        return null;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String string) {
        this.ruleId = string;
    }

    @Override
    public int getType() {
        if ("Error".equalsIgnoreCase(this.getResultType())) {
            return 0;
        }
        if ("Warning".equalsIgnoreCase(this.getResultType())) {
            return 1;
        }
        return 2;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String string) {
        this.script = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String string) {
        this.purpose = string;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String string) {
        this.object = string;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String string) {
        this.engineName = string;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String string) {
        this.variable = string;
    }

    public DRLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(DRLibrary dRLibrary) {
        this.library = dRLibrary;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public boolean hasEvalError() {
        return this.hasEvalError;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String string) {
        this.resultType = string;
    }

    public DRCustomScript copy() {
        return new DRCustomScript(this.name, this.ruleId, this.purpose, this.object, this.engineName, this.script, this.variable, this.scriptEngineManager, this.library, this.function);
    }
}

