/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.model.design.undo.relational.ColumnPreserver;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;

public class TableUpdateEdit
extends UpdateDO_Edit {
    private Table oldTableBackup;
    private Table oldTable;
    private Table newTable;
    private List removedColumnsEdit = new ArrayList();
    private List removedKeysEdit = new ArrayList();
    private List newColumns = new ArrayList();
    private List newIndexes = new ArrayList();
    private List newIndOrder = new ArrayList();
    private List oldIndOrder = new ArrayList();
    private List columnPreservers = new ArrayList();
    private boolean createEdits = true;
    private List<Index> indexesForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForCreate;
    private List<FKIndexAssociation.FKMemento> fkMementosForRemove;
    private List<DesignObjectEdit> fkEdits = new ArrayList<DesignObjectEdit>();
    List todelete = new ArrayList();
    List updatedIndexes = new ArrayList();
    List updatedColumns = new ArrayList();

    public TableUpdateEdit(Table table, Table table2, List<Index> list, List<FKIndexAssociation.FKMemento> list2, List<FKIndexAssociation.FKMemento> list3, List<FKIndexAssociation.FKMemento> list4, List<Table.ColumnGroup> list5) {
        super(table);
        this.oldTableBackup = new Table(table.getDesignPart());
        this.oldTable = table;
        this.newTable = table2;
        table.backupTo(this.oldTableBackup);
        this.indexesForUpdate = list;
        this.fkMementosForCreate = list3;
        this.fkMementosForUpdate = list2;
        this.fkMementosForRemove = list4;
    }

    @Override
    public void applyUpdates() {
        this.newTable.applyChangesTo(this.oldTable);
        this.changeStructure(this.createEdits);
        this.newTable.applySpatialColumndefinitions(this.oldTable);
        this.createEdits = false;
    }

    @Override
    protected void restoreObject() {
        this.oldTableBackup.applyChangesTo(this.oldTable);
        this.restoreStructure();
        this.oldTableBackup.applySpatialColumndefinitions(this.oldTable);
        for (int i = this.fkEdits.size() - 1; i > -1; --i) {
            this.fkEdits.get(i).undo();
        }
    }

    private void changeStructure(boolean bl) {
        this.changeColumns(bl);
        this.changeIndexes(bl);
        this.changeForeignKeys(bl);
        this.changeColumnGroups();
    }

    private void saveIndexOrder(List list, List list2) {
        for (Index index : list) {
            this.oldIndOrder.add(index.getObjectID());
        }
        for (Index index : list2) {
            this.newIndOrder.add(index.getObjectID());
        }
    }

    private void setIndexOrder(Table table, List list) {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        for (String string : list) {
            Index index = (Index)table.getKeySet().getObjectByID(string);
            if (index == null) continue;
            arrayList.add(index);
        }
        ((IndexSet)table.getKeySet()).addAndApplyOrderFromList(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    private void changeIndexes(boolean bl) {
        if (bl) {
            IndWr indWr;
            Object object;
            for (Index object22 : this.indexesForUpdate) {
                if (object22.isPK()) continue;
                object22.restoreFromMemento(object22.getIndexMemento());
            }
            List list = this.oldTable.getAllInds_PK_UK_NoFKeys();
            List indWr2 = this.newTable.getAllInds_PK_UK_NoFKeys();
            this.saveIndexOrder(list, indWr2);
            this.todelete.clear();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Index index = (Index)iterator.next();
                if (index.isFK() || (object = (Index)this.getObjectByID(indWr2, index.getObjectID())) == null && this.oldTable.isBST() && index.isOidKey() && (object = (Index)this.newTable.getOidKey()) == null && this.newTable.isBST()) continue;
                if (object == null) {
                    this.todelete.add(index);
                    continue;
                }
                indWr = new IndWr();
                indWr.old = index;
                indWr.omem = index.getIndexMemento();
                indWr.nmem = ((Index)object).getIndexMemento();
                if (!this.oldTable.getAppView().getXMLTransformationManager().equal(index, object, false)) {
                    indWr.old.restoreFromMemento(indWr.nmem);
                }
                indWr.old.setMarkedGenerate(indWr.nmem.generate_in_DDL);
                this.updatedIndexes.add(indWr);
            }
            for (Index index : this.todelete) {
                object = new IndexRemoveEdit(index);
                ((CompoundEdit)object).end();
                this.removedKeysEdit.add(object);
                index.remove();
            }
            for (Index index : indWr2) {
                object = (Index)this.getObjectByID(list, index.getObjectID());
                if (object == null && this.oldTable.isBST() && index.isOidKey()) {
                    object = (Index)this.oldTable.getOidKey();
                }
                if (object == null) {
                    indWr = new IndWr();
                    indWr.old = this.oldTable.createIndex(index.getObjectID());
                    indWr.nmem = index.getIndexMemento();
                    indWr.old.restoreFromMemento(indWr.nmem);
                    this.newIndexes.add(indWr);
                }
                if (!index.isFK()) continue;
            }
        } else {
            void var3_10;
            for (IndWr i : this.newIndexes) {
                i.old.setContainerObject(this.oldTable);
                i.old.restoreFromMemento(i.nmem);
                this.oldTable.add(i.old);
            }
            for (IndWr indWr : this.updatedIndexes) {
                indWr.old.restoreFromMemento(indWr.nmem);
            }
            boolean bl2 = false;
            while (var3_10 < this.removedKeysEdit.size()) {
                UndoableEdit undoableEdit = (UndoableEdit)this.removedKeysEdit.get((int)var3_10);
                undoableEdit.redo();
                ++var3_10;
            }
        }
        this.setIndexOrder(this.oldTable, this.newIndOrder);
    }

    private void changeColumns(boolean bl) {
        Object[] objectArray = this.oldTable.getElements();
        Object[] objectArray2 = this.newTable.getElements();
        if (bl) {
            Object object;
            Object object2;
            this.todelete.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Column column = (Column)objectArray[i];
                object2 = (Column)this.getObjectByID(objectArray2, column.getObjectID());
                if (object2 == null && this.oldTable.isBST()) {
                    object2 = column.isOid() ? (Column)this.oldTable.getOidElement() : (Column)this.getObjectByStructAttributeID(objectArray2, column.getStructAttributeID());
                }
                if (object2 == null) {
                    this.todelete.add(column);
                    continue;
                }
                object = new ColWr();
                ((ColWr)object).old = column;
                ((ColWr)object).upd = object2;
                ((ColWr)object).bckup = (Column)this.oldTableBackup.getElementByID(column.getObjectID());
                if (!this.oldTable.getAppView().getXMLTransformationManager().equal(column, object2, false)) {
                    ((ColWr)object).upd.copy(((ColWr)object).old);
                }
                ((ColWr)object).newpos = ((ContainedObject)object2).getIndex();
                ((ColWr)object).oldpos = column.getIndex();
                this.updatedColumns.add(object);
            }
            for (Column column : this.todelete) {
                object2 = new ColumnRemoveEdit(column);
                ((CompoundEdit)object2).end();
                this.removedColumnsEdit.add(object2);
                column.remove();
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object3;
                object2 = (Column)objectArray2[i];
                object = (Column)this.getObjectByID(objectArray, ((ModelIDObject)object2).getObjectID());
                if (object == null && this.oldTable.isBST()) {
                    if (((ContainedObject)object2).isOid()) {
                        object = (Column)this.oldTable.getOidElement();
                    } else {
                        object3 = ((ContainedObject)object2).getStructAttributeID();
                        if (object3 != null && !"".equals(object3)) {
                            object = (Column)this.oldTable.getElementByStructAttributeID((String)object3);
                        }
                    }
                }
                if (object != null) continue;
                object3 = this.oldTable.createColumn(((ContainedObject)object2).getName(), ((ModelIDObject)object2).getObjectID());
                ((Column)object2).copy((DesignObject)object3);
                this.newColumns.add(object3);
                ((ContainedObject)object3).moveToIndex(i);
            }
            for (ColWr colWr : this.updatedColumns) {
                colWr.old.moveToIndex(colWr.newpos);
            }
            for (Column column : this.newColumns) {
                object2 = new ColumnPreserver(column);
                this.columnPreservers.add(object2);
            }
        } else {
            for (ColWr colWr : this.updatedColumns) {
                colWr.upd.copy(colWr.old);
                colWr.old.moveToIndex(colWr.newpos);
            }
            for (int i = 0; i < this.removedColumnsEdit.size(); ++i) {
                UndoableEdit undoableEdit = (UndoableEdit)this.removedColumnsEdit.get(i);
                undoableEdit.redo();
            }
            for (ColumnPreserver columnPreserver : this.columnPreservers) {
                columnPreserver.restore();
            }
        }
    }

    private void changeColumnGroups() {
        List list = this.newTable.getColumnGroupsSet();
        Iterator iterator = list.iterator();
        this.oldTable.getColumnGroupsSet().clear();
        while (iterator.hasNext()) {
            Table.ColumnGroup columnGroup = (Table.ColumnGroup)iterator.next();
            Table table = this.newTable;
            table.getClass();
            Table.ColumnGroup columnGroup2 = table.new Table.ColumnGroup(columnGroup.getName());
            columnGroup.copy(columnGroup2);
            this.oldTable.addColumnGroup(columnGroup2);
        }
    }

    private void changeForeignKeys(boolean bl) {
        if (bl) {
            this.createForeignKeyEdits();
        } else {
            for (DesignObjectEdit designObjectEdit : this.fkEdits) {
                designObjectEdit.redo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeyEdits() {
        Object object;
        Object object2;
        FKIndexAssociation fKIndexAssociation;
        if (!this.fkMementosForCreate.isEmpty()) {
            boolean bl = this.oldTable.getDesign().isPropagatePKChahges();
            try {
                this.oldTable.getDesign().setPropagatePKChahges(false);
                for (FKIndexAssociation.FKMemento fKMemento : this.fkMementosForCreate) {
                    fKIndexAssociation = fKMemento.fk;
                    fKIndexAssociation.resetFromMemento(fKMemento);
                    this.oldTable.getKeySet().remove(fKIndexAssociation.getLocalFKIndex());
                    object2 = (Index)fKMemento.remoteTable.getKeyObject(fKMemento.remoteKeyID);
                    object = this.oldTable.addFK((KeyObject)object2);
                    ((DesignObject)object).setObjectID(fKIndexAssociation.getObjectID());
                    fKIndexAssociation.restoreToCandidateOrigFK((FKIndexAssociation)object, fKMemento.dpv);
                    ((FKIndexAssociation)object).resetEdgeParams();
                    this.addFKCreateEdit((FKIndexAssociation)object);
                }
            }
            finally {
                this.oldTable.getDesign().setPropagatePKChahges(bl);
                this.fkMementosForCreate.clear();
            }
        }
        if (!this.fkMementosForUpdate.isEmpty()) {
            Object[] objectArray = this.oldTable.getFKAssociations();
            for (FKIndexAssociation.FKMemento fKMemento : this.fkMementosForUpdate) {
                fKIndexAssociation = (FKIndexAssociation)this.getObjectByID(objectArray, fKMemento.fk.getObjectID());
                if (fKIndexAssociation != null) {
                    FKIndexAssociation fKIndexAssociation2 = fKIndexAssociation;
                    fKIndexAssociation2.getClass();
                    object2 = fKIndexAssociation2.new FKIndexAssociation.FKMemento(fKIndexAssociation);
                    object = fKIndexAssociation.getAppView().getXMLTransformationManager().getFilteredXMLString(fKIndexAssociation);
                    fKMemento.copyTo((FKIndexAssociation.FKMemento)object2);
                    FKUpdateEdit fKUpdateEdit = new FKUpdateEdit(fKIndexAssociation, (FKIndexAssociation.FKMemento)object2);
                    fKUpdateEdit.end();
                    fKUpdateEdit.applyUpdates();
                    String string = fKIndexAssociation.getAppView().getXMLTransformationManager().getFilteredXMLString(fKIndexAssociation);
                    if (!((String)object).equals(string)) {
                        fKIndexAssociation.setDirty(true);
                    }
                    this.fkEdits.add(fKUpdateEdit);
                    continue;
                }
                object2 = this.addFKUpdateEdit(fKMemento);
                ((FKUpdateEdit)object2).applyUpdates();
            }
            this.fkMementosForUpdate.clear();
        }
        try {
            for (FKIndexAssociation.FKMemento fKMemento : this.fkMementosForRemove) {
                FKIndexAssociation fKIndexAssociation3 = fKMemento.fk.getOriginatingFK();
                this.addFKRemoveEdit(fKIndexAssociation3);
                this.oldTable.removeFKAssociation(fKIndexAssociation3);
            }
        }
        finally {
            this.fkMementosForRemove.clear();
        }
    }

    private Object getObjectByID(Object[] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof ModelIDObject) || !((ModelIDObject)objectArray[i]).getObjectID().equals(string)) continue;
            return objectArray[i];
        }
        return null;
    }

    private Object getObjectByStructAttributeID(Object[] objectArray, String string) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof ContainedObject) || !((ContainedObject)objectArray[i]).getStructAttributeID().equals(string)) continue;
            return objectArray[i];
        }
        return null;
    }

    private Object getObjectByID(List list, String string) {
        for (Object e : list) {
            if (!(e instanceof ModelIDObject) || !((ModelIDObject)e).getObjectID().equals(string)) continue;
            return e;
        }
        return null;
    }

    private void restoreStructure() {
        UndoableEdit undoableEdit;
        for (Column column : this.newColumns) {
            column.remove();
        }
        for (int i = this.removedColumnsEdit.size() - 1; i > -1; --i) {
            undoableEdit = (UndoableEdit)this.removedColumnsEdit.get(i);
            undoableEdit.undo();
        }
        for (ColWr colWr : this.updatedColumns) {
            colWr.bckup.copy(colWr.old);
            colWr.old.moveToIndex(colWr.oldpos);
        }
        for (IndWr indWr : this.newIndexes) {
            indWr.old.remove();
        }
        for (IndWr indWr : this.updatedIndexes) {
            indWr.old.restoreFromMemento(indWr.omem);
            indWr.old.setIndexState(indWr.bckstate);
        }
        for (int i = this.removedKeysEdit.size() - 1; i > -1; --i) {
            undoableEdit = (UndoableEdit)this.removedKeysEdit.get(i);
            undoableEdit.undo();
        }
        this.setIndexOrder(this.oldTable, this.oldIndOrder);
    }

    public FKUpdateEdit addFKUpdateEdit(FKIndexAssociation.FKMemento fKMemento) {
        FKUpdateEdit fKUpdateEdit = new FKUpdateEdit(fKMemento.fk, fKMemento);
        fKUpdateEdit.end();
        this.fkEdits.add(fKUpdateEdit);
        return fKUpdateEdit;
    }

    public FKCreateEdit addFKCreateEdit(FKIndexAssociation fKIndexAssociation) {
        FKCreateEdit fKCreateEdit = new FKCreateEdit(fKIndexAssociation);
        fKCreateEdit.end();
        this.fkEdits.add(fKCreateEdit);
        return fKCreateEdit;
    }

    public FKRemoveEdit addFKRemoveEdit(FKIndexAssociation fKIndexAssociation) {
        FKRemoveEdit fKRemoveEdit = new FKRemoveEdit(fKIndexAssociation);
        fKRemoveEdit.end();
        this.fkEdits.add(fKRemoveEdit);
        return fKRemoveEdit;
    }

    class ColWr {
        Column old;
        Column upd;
        Column bckup;
        int newpos;
        int oldpos;

        ColWr() {
        }
    }

    class IndWr {
        Index old;
        Index upd;
        Index bckup;
        IndexMemento omem;
        IndexMemento nmem;
        String bckstate;

        IndWr() {
        }
    }
}

