/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexColumnPreserver;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.DesignPartView;

public class IndexUpdateEdit
extends UpdateDO_Edit {
    private IndexMemento oldmem;
    private IndexMemento newmem;
    private Index index;
    private boolean first = true;
    private List fkedits = new ArrayList();
    private List newColumns = new ArrayList();
    private List toremoveCols = new ArrayList();
    private List preservers = new ArrayList();
    private List columns = new ArrayList();
    private List old_order = new ArrayList();
    private Table table;
    private String index_id;

    public IndexUpdateEdit(Index index, IndexMemento indexMemento) {
        super(index);
        Object object;
        this.index = index;
        DesignPartView designPartView = index.getDesignPart().getMainView();
        this.oldmem = index.getIndexMemento();
        this.newmem = new IndexMemento(index);
        indexMemento.copyto(this.newmem);
        this.index_id = index.getObjectID();
        for (Column object3 : index.getElementsCollection()) {
            IndexMemento.ColWr colWr = this.getColWr(indexMemento.columns, object3.getObjectID());
            if (colWr == null) {
                this.toremoveCols.add(object3.getObjectID());
                object = new IndexColumnPreserver(index, object3);
                this.preservers.add(object);
            }
            object = new IndexMemento.ColWr(indexMemento);
            ((IndexMemento.ColWr)object).col_id = object3.getObjectID();
            ((IndexMemento.ColWr)object).sort_order = index.getColumnSortOrder(object3);
        }
        for (IndexMemento.ColWr colWr : indexMemento.columns) {
            this.columns.add(colWr);
            Column column = (Column)index.getElementByID(colWr.col_id);
            if (column != null) continue;
            this.newColumns.add(colWr);
        }
        this.table = (Table)index.getContainerWithKeyObject();
        if (!index.isPK() && "Primary Constraint".equalsIgnoreCase(indexMemento.index_state) && index.hasColumnInOptionalFK()) {
            for (IndexMemento.ColWr colWr : indexMemento.columns) {
                object = (Column)this.table.getElementByID(colWr.col_id);
                if (object == null) continue;
                for (FKIndexAssociation fKIndexAssociation : ((Column)object).getAllFKs()) {
                    if (fKIndexAssociation.isMandatory()) continue;
                    FKIndexAssociation.FKMemento fKMemento = fKIndexAssociation.getFKMemento(designPartView);
                    fKMemento.mandatory = true;
                    FKUpdateEdit fKUpdateEdit = new FKUpdateEdit(fKIndexAssociation, fKMemento);
                    fKUpdateEdit.end();
                    this.fkedits.add(fKUpdateEdit);
                }
            }
        }
    }

    @Override
    public void applyUpdates() {
        Column column;
        Index index = null;
        if (this.index_id != null) {
            index = (Index)this.table.getKeySet().getObjectByID(this.index_id);
        }
        if (index != null) {
            this.index = index;
        }
        for (Object object : this.toremoveCols) {
            column = (Column)this.index.getElementByID((String)object);
            if (column == null) continue;
            this.index.remove(column);
        }
        for (Object object : this.newColumns) {
            column = (Column)this.table.getElementByID(((IndexMemento.ColWr)object).col_id);
            if (column == null) continue;
            this.index.add(column);
            this.index.setColumnSortOrder(column, ((IndexMemento.ColWr)object).sort_order);
        }
        if (this.index != null) {
            this.index.restoreFromMemento(this.newmem);
        }
        for (Object object : this.fkedits) {
            if (this.first) {
                ((FKUpdateEdit)object).applyUpdates();
                continue;
            }
            ((UpdateDO_Edit)object).redo();
        }
        this.first = false;
    }

    @Override
    protected void restoreObject() {
        Index index = (Index)this.table.getKeySet().getObjectByID(this.index_id);
        if (index != null) {
            this.index = index;
        }
        for (Object object : this.newColumns) {
            Column column = (Column)this.index.getElementByID(((IndexMemento.ColWr)object).col_id);
            if (column == null) continue;
            this.index.remove(column);
        }
        for (Object object : this.preservers) {
            ((IndexColumnPreserver)object).restore();
        }
        this.index.restoreFromMemento(this.oldmem);
        for (Object object : this.fkedits) {
            ((UpdateDO_Edit)object).undo();
        }
    }

    private IndexMemento.ColWr getColWr(List list, String string) {
        for (IndexMemento.ColWr colWr : list) {
            if (!colWr.col_id.equals(string)) continue;
            return colWr;
        }
        return null;
    }

    private void sortColumns(Index index, List list) {
        int n = 0;
        for (IndexMemento.ColWr colWr : list) {
            Column column = (Column)index.getElementByID(colWr.col_id);
            if (column == null) continue;
            index.setColumnSortOrder(column, colWr.sort_order);
            index.moveToIndex(column, n);
            ++n;
        }
    }
}

