/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class FKColumnPreserver {
    private Column column;
    private Column backup;
    private String id;
    private Table table;
    private int position;
    private int[][] occurences;
    private KeyObject[] keys;
    List delegates = new ArrayList();
    protected List mappings = new ArrayList();

    public void preserve(Column column) {
        this.column = column;
        this.backup = new Column(column.getDesignPart());
        this.column.copy(this.backup);
        this.id = this.column.getObjectID();
        this.backup.setObjectID(this.id);
        this.position = this.column.getIndex();
        this.table = (Table)this.column.getContainerWithKeyObject();
        this.keys = this.table.getKeys();
        this.occurences = this.occursInCandidateKeys(this.keys, this.column);
        this.saveMappings(this.column, this.mappings);
        FKColumnPreserver.saveFKandDelegates(column, this.delegates);
    }

    public void restore(Column column) {
        this.backup.copy(column);
        column.setObjectID(this.id);
        this.table.moveToIndex(column, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, column, this.occurences);
        }
        this.restoreMappings(this.mappings);
        FKColumnPreserver.restoreFKandDelegates(column, this.delegates);
    }

    public void restore() {
        Column column = (Column)this.table.getElementByID(this.id);
        if (column == null) {
            column = this.column;
            this.column.setObjectID(this.id);
            this.table.add(column);
        }
        this.backup.copy(column);
        this.table.moveToIndex(column, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, column, this.occurences);
        }
        this.restoreMappings(this.mappings);
        FKColumnPreserver.restoreFKandDelegates(column, this.delegates);
    }

    protected int[][] occursInCandidateKeys(KeyObject[] keyObjectArray, Column column) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].contains(column)) continue;
            arrayList.add(new int[]{i, keyObjectArray[i].getIndexOf(column)});
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }

    protected void insertInCandidateKeys(KeyObject[] keyObjectArray, Column column, int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            keyObjectArray[nArray2[0]].add(column);
            keyObjectArray[nArray2[0]].moveToIndex(column, nArray2[1]);
        }
    }

    public static void saveFKandDelegates(Column column, List list) {
        for (Column.FK_And_Delegate_Holder fK_And_Delegate_Holder : column.getAllDelegatesAndFK()) {
            Column.DelegateHolder delegateHolder = column.new Column.DelegateHolder();
            delegateHolder.fkid = fK_And_Delegate_Holder.fk.getObjectID();
            delegateHolder.delegateID = fK_And_Delegate_Holder.delegateColumn.getObjectID();
            list.add(delegateHolder);
        }
    }

    public static void restoreFKandDelegates(Column column, List list) {
        for (Column.DelegateHolder delegateHolder : list) {
            column.addFKAssociation(delegateHolder.delegateID, delegateHolder.fkid);
        }
    }

    public void saveMappings(Column column, List list) {
        ColumnMappingWr columnMappingWr = new ColumnMappingWr();
        columnMappingWr.object = column;
        columnMappingWr.table = (Table)column.getContainerWithKeyObject();
        list.add(columnMappingWr);
        columnMappingWr.mappings.addAll(column.getDesign().getExtendedMap().getOrCreateCollector(column).getAllMappings());
    }

    public void restoreMappings(List list) {
        for (ColumnMappingWr columnMappingWr : list) {
            for (XtdMapping xtdMapping : columnMappingWr.mappings) {
                boolean bl;
                if (columnMappingWr.object.getObjectID().equals(xtdMapping.getDeletedID())) {
                    Column column = (Column)columnMappingWr.table.getLocalObject(columnMappingWr.object.getObjectID());
                    if (column != null) {
                        columnMappingWr.object = column;
                    }
                    columnMappingWr.object.getDesign().getExtendedMap().restoreDeletedMapping(xtdMapping, columnMappingWr.object);
                    continue;
                }
                boolean bl2 = bl = false;
            }
        }
    }

    public class ColumnMappingWr {
        public List mappings = new ArrayList();
        Column object;
        Table table;
    }
}

