/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.text.MessageFormat;
import javax.swing.undo.CannotRedoException;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class UpdateDO_Edit
extends DesignObjectEdit {
    private static final Logger LOGGER = new Logger(UpdateDO_Edit.class);
    private DesignObject designObject;

    public UpdateDO_Edit(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected abstract void restoreObject();

    public abstract void applyUpdates();

    @Override
    public String getRedoPresentationName() {
        if (this.designObject != null) {
            return MessageFormat.format(Messages.getString("UpdateDO_Edit.RedoUpdate"), this.designObject.getLongName());
        }
        return Messages.getString("UpdateDO_Edit.RedoUpdate");
    }

    @Override
    public String getUndoPresentationName() {
        if (this.designObject != null) {
            return MessageFormat.format(Messages.getString("UpdateDO_Edit.UndoUpdate"), this.designObject.getLongName());
        }
        return Messages.getString("UpdateDO_Edit.UndoUpdate");
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            super.redo();
            this.applyUpdates();
        }
        catch (Exception exception) {
            LOGGER.error("Error in UpdateDO_Edit.redo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        try {
            DesignObjectEdit.UNDOABLE_ADD = true;
            super.undo();
            this.restoreObject();
        }
        catch (Exception exception) {
            LOGGER.error("Error in UpdateDO_Edit.undo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
        finally {
            DesignObjectEdit.UNDOABLE_ADD = false;
        }
    }
}

