/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class DP_UndoManager
extends UndoManager {
    private boolean inUndoRedoMode = false;
    private boolean locked = false;
    private int UNDO_REDO_LIST_SIZE = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void redo() throws CannotRedoException {
        try {
            if (this.canRedo()) {
                this.inUndoRedoMode = true;
                super.redo();
            }
        }
        finally {
            this.inUndoRedoMode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undo() throws CannotUndoException {
        try {
            if (this.canUndo()) {
                this.inUndoRedoMode = true;
                super.undo();
            }
        }
        finally {
            this.inUndoRedoMode = false;
        }
    }

    public boolean isInUndoRedoMode() {
        return this.inUndoRedoMode;
    }

    public UndoableEdit getLastEdit() {
        int n = this.edits.size();
        if (n > 0) {
            return (UndoableEdit)this.edits.elementAt(n - 1);
        }
        return null;
    }

    public boolean removeEdit(UndoableEdit undoableEdit) {
        return this.edits.removeElement(undoableEdit);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        if (this.isLocked()) {
            return false;
        }
        if (!this.edits.contains(undoableEdit)) {
            return super.addEdit(undoableEdit);
        }
        return true;
    }

    public List<UndoableEdit> getEdits() {
        ArrayList<UndoableEdit> arrayList = new ArrayList<UndoableEdit>();
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((UndoableEdit)enumeration.nextElement());
        }
        return arrayList;
    }

    public List<UndoableEdit> getUndoList() {
        List<UndoableEdit> list = this.getEdits();
        ArrayList<UndoableEdit> arrayList = new ArrayList<UndoableEdit>();
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit != null) {
            int n;
            for (int i = n = list.indexOf(undoableEdit); i >= 0 && arrayList.size() < this.UNDO_REDO_LIST_SIZE; --i) {
                UndoableEdit undoableEdit2 = list.get(i);
                if (!undoableEdit2.isSignificant()) continue;
                arrayList.add(undoableEdit2);
            }
        }
        return arrayList;
    }

    public List<UndoableEdit> getRedoList() {
        List<UndoableEdit> list = this.getEdits();
        ArrayList<UndoableEdit> arrayList = new ArrayList<UndoableEdit>();
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit != null) {
            int n;
            for (int i = n = list.indexOf(undoableEdit); i < list.size() && arrayList.size() < this.UNDO_REDO_LIST_SIZE; ++i) {
                UndoableEdit undoableEdit2 = list.get(i);
                if (!undoableEdit2.isSignificant()) continue;
                arrayList.add(undoableEdit2);
            }
        }
        return arrayList;
    }

    public void undoToEdit(UndoableEdit undoableEdit) {
        this.undoTo(undoableEdit);
    }

    public void redoToEdit(UndoableEdit undoableEdit) {
        UndoableEdit undoableEdit2 = this.editToBeRedone();
        while (undoableEdit2 != null) {
            this.redo();
            if (undoableEdit2 == undoableEdit) {
                return;
            }
            undoableEdit2 = this.editToBeRedone();
        }
    }
}

