/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.text.MessageFormat;
import javax.swing.undo.CannotRedoException;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class CreateDO_Edit
extends DesignObjectEdit {
    private static final Logger LOGGER = new Logger(CreateDO_Edit.class);
    private DesignObject designObject;

    public CreateDO_Edit(DesignObject designObject) {
        this.designObject = designObject;
    }

    protected abstract void restoreObject();

    protected abstract void removeObject();

    @Override
    public String getRedoPresentationName() {
        return MessageFormat.format(Messages.getString("CreateDO_Edit.RedoCreate"), this.designObject.getLongName());
    }

    @Override
    public String getUndoPresentationName() {
        return MessageFormat.format(Messages.getString("CreateDO_Edit.UndoCreate"), this.designObject.getLongName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        try {
            DesignObjectEdit.UNDOABLE_ADD = true;
            this.restoreObject();
            super.redo();
        }
        catch (Exception exception) {
            LOGGER.error("Error in CreateDO_Edit.redo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
        finally {
            DesignObjectEdit.UNDOABLE_ADD = false;
        }
    }

    @Override
    public void undo() {
        try {
            super.undo();
            this.removeObject();
        }
        catch (Exception exception) {
            LOGGER.error("Error in CreateDO_Edit.undo \n" + this.getUndoPresentationName() + "\n" + exception.getMessage());
        }
    }
}

