/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;

public class TableViewProxyUDBv81
extends TableViewProxyUDB
implements ModelObjectSetListener,
StorageObjectListener {
    protected String federated = "NO";

    public TableViewProxyUDBv81(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyUDBv81.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
    }

    public TableViewProxyUDBv81(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyUDBv81.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
    }

    public String getFederated() {
        return this.federated;
    }

    public void setFederated(String string) {
        if (StorageObjectConstantsUDB.checkYesNo(string)) {
            this.federated = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogUDBv81 tableViewPropertyDialogUDBv81 = new TableViewPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableViewPropertyDialogUDBv81.show();
        }
    }

    private void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)iterator.next();
            triggerUDBv81.addObjectListener(this);
            if (triggerUDBv81.getView() != null && triggerUDBv81.getView() == this) {
                triggerUDBv81.setParent(this.triggers);
                this.triggers.add(triggerUDBv81);
                continue;
            }
            this.triggers.remove(triggerUDBv81);
        }
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.getNumberOfChildren() - 1) {
            return this.triggers;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.triggers) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.triggers) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerUDBv81) {
            TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)objectChangeEvent.getAffected();
            if (triggerUDBv81.getView() != null && triggerUDBv81.getView() == this) {
                triggerUDBv81.setParent(this.triggers);
                this.triggers.add(triggerUDBv81);
            } else {
                this.triggers.remove(triggerUDBv81);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerUDBv81) {
                TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)modelObjectSetEvent.getAffected();
                triggerUDBv81.addObjectListener(this);
                if (triggerUDBv81.getView() != null && triggerUDBv81.getView() == this) {
                    triggerUDBv81.setParent(this.triggers);
                    this.triggers.add(triggerUDBv81);
                } else {
                    this.triggers.remove(triggerUDBv81);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TriggerUDBv81) {
            TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)modelObjectSetEvent.getAffected();
            this.triggers.remove(triggerUDBv81);
            triggerUDBv81.removeObjectListener(this);
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableView tableView = (TableView)storageDesign.getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyUDBv81 tableViewProxyUDBv81 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignUDBv81)storageDesign).getTableViewProxySet().getProxy(tableView.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            tableViewProxyUDBv81 = (TableViewProxyUDBv81)relationalObjectProxy;
        }
        if (tableViewProxyUDBv81 != null) {
            tableViewProxyUDBv81.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schemaUDBv81 == null) {
                    SchemaUDBv81 schemaUDBv812 = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().createSchema();
                    schemaUDBv812.setName(this.getSchema().getName());
                    schemaUDBv812.setRawObject(true);
                    tableViewProxyUDBv81.setSchema(schemaUDBv812);
                } else {
                    tableViewProxyUDBv81.setSchema(schemaUDBv81);
                }
            }
            tableViewProxyUDBv81.setCheckOption(this.getCheckOption());
            tableViewProxyUDBv81.setCheckOptionScope(this.getCheckOptionScope());
            tableViewProxyUDBv81.setOidColumnName(this.getOidColumnName());
            tableViewProxyUDBv81.setOidColumnUniqueness(this.isOidColumnUniqueness());
            tableViewProxyUDBv81.setDefinition(this.getDefinition());
            tableViewProxyUDBv81.setComment(this.getComment());
            tableViewProxyUDBv81.setCommentInRDBMS(this.getCommentInRDBMS());
            tableViewProxyUDBv81.setRawObject(false);
        }
    }
}

