/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.TriggerPropertyDialogUDB;

public class TriggerUDB
extends Trigger {
    protected TableProxyUDB table;
    protected OwnerUDB owner;
    private String columns = "";
    private ColumnSet columnSet = null;
    protected String scope = SCOPE_TYPES[0];
    protected String ref_OLD_AS = "";
    protected String ref_NEW_AS = "";
    protected String OLD_TABLE_AS = "";
    protected String NEW_TABLE_AS = "";
    protected String condition = "";
    protected int order = 1;
    private SchemaUDB schema;
    public static final String[] TRIGGER_TIMES = new String[]{"NO CASCADE BEFORE", "AFTER"};
    private static Set triggerTimeSet = null;
    public static final String[] SCOPE_TYPES = new String[]{"FOR EACH ROW", "FOR EACH STATEMENT"};
    private static Set scopeSet = null;

    public TriggerUDB(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime(TRIGGER_TIMES[0]);
    }

    public TableProxyUDB getTable() {
        return this.table;
    }

    public void setTable(TableProxyUDB tableProxyUDB) {
        if (tableProxyUDB != null) {
            this.table = tableProxyUDB;
            this.fireDataFieldChange();
        }
    }

    public String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    @Override
    protected boolean checkTriggerTime(String string) {
        if (triggerTimeSet == null) {
            triggerTimeSet = new HashSet();
            triggerTimeSet.addAll(Arrays.asList(this.getTriggerTimes()));
        }
        return triggerTimeSet.contains(string);
    }

    public static String[] getScopeTypes() {
        return SCOPE_TYPES;
    }

    protected boolean checkScope(String string) {
        if (scopeSet == null) {
            scopeSet = new HashSet();
            scopeSet.addAll(Arrays.asList(TriggerUDB.getScopeTypes()));
        }
        return scopeSet.contains(string);
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getColumnSet().contains(string2)) {
            this.getColumnSet().add(string2);
        }
    }

    protected void recreateColumnSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(string);
        } else {
            this.addColumn(string);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
        this.fireDataFieldChange();
    }

    public String getNEW_TABLE_AS() {
        return this.NEW_TABLE_AS;
    }

    public void setNEW_TABLE_AS(String string) {
        this.NEW_TABLE_AS = string;
    }

    public String getOLD_TABLE_AS() {
        return this.OLD_TABLE_AS;
    }

    public void setOLD_TABLE_AS(String string) {
        this.OLD_TABLE_AS = string;
        this.fireDataFieldChange();
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB ownerUDB) {
        this.owner = ownerUDB;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public String getRef_NEW_AS() {
        return this.ref_NEW_AS;
    }

    public void setRef_NEW_AS(String string) {
        this.ref_NEW_AS = string;
        this.fireDataFieldChange();
    }

    public String getRef_OLD_AS() {
        return this.ref_OLD_AS;
    }

    public void setRef_OLD_AS(String string) {
        this.ref_OLD_AS = string;
        this.fireDataFieldChange();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (this.checkScope(string)) {
            this.scope = string;
            this.fireDataFieldChange();
        }
    }

    public boolean isScopeForEachRow() {
        return this.getScope().equalsIgnoreCase(SCOPE_TYPES[0]);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TriggerPropertyDialogUDB triggerPropertyDialogUDB = new TriggerPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            triggerPropertyDialogUDB.show();
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getSchema() != null) {
            string = this.getSchema().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TRIGGER_ICON", 16);
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

