/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;

public class TableViewProxyUDB
extends TableViewProxy {
    private OwnerUDB owner = null;
    private SchemaUDB schema = null;
    private String oidColumnName = "Oid";
    private boolean oidColumnUniqueness = true;
    public static final String CASCADED_CHECK_OPTIONS = "CASCADED";
    public static final String LOCAL_CHECK_OPTIONS = "LOCAL";
    public static String[] availableCheckOptionScopes = new String[]{"CASCADED", "LOCAL"};
    protected String checkOptionScope = "CASCADED";
    protected StorageObjectCollection triggers;

    public TableViewProxyUDB(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
    }

    public TableViewProxyUDB(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public void setOwner(OwnerUDB ownerUDB) {
        this.owner = ownerUDB;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(schemaObject);
            if (storageObject != null) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getLongSuperViewName() {
        TableViewProxyUDB tableViewProxyUDB;
        TableView tableView = (TableView)this.getObject();
        if (!tableView.isRoot() && tableView.getTypeSubstitution() != null && (tableViewProxyUDB = (TableViewProxyUDB)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getTypeSubstitution().getParentContainerObject().getObjectID())) != null) {
            return tableViewProxyUDB.getLongName();
        }
        return "";
    }

    public static String[] getAvailableCheckOptionScopes() {
        return availableCheckOptionScopes;
    }

    public void setCheckOptionScope(String string) {
        this.checkOptionScope = string;
    }

    public String getCheckOptionScope() {
        return this.checkOptionScope;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogUDB tableViewPropertyDialogUDB = new TableViewPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tableViewPropertyDialogUDB.show();
        }
    }

    public String getOidColumnName() {
        return this.oidColumnName;
    }

    public void setOidColumnName(String string) {
        this.oidColumnName = string;
    }

    public boolean isOidColumnUniqueness() {
        return this.oidColumnUniqueness;
    }

    public void setOidColumnUniqueness(boolean bl) {
        this.oidColumnUniqueness = bl;
    }

    public String getSuperViewName() {
        TableView tableView = (TableView)this.getObject();
        if (!tableView.isRoot() && tableView.getTypeSubstitution() != null) {
            return tableView.getTypeSubstitution().getParentContainerObject().getName();
        }
        return "";
    }

    public boolean isBasedOnStructuredType() {
        return ((TableView)this.getObject()).isBST();
    }

    @Override
    public StorageObject getUserSchema() {
        if (this.getSchema() != null) {
            return this.getSchema();
        }
        return this.getOwner();
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            if (this.triggers != null) {
                this.triggers.addAllElementsTo(arrayList);
            }
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }
}

