/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.editor.storage.udb.StructuredTypePropertyDialogUDB;

public class StructuredTypeProxyUDB
extends StructuredTypeProxy
implements DataTypeObject {
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO = new String[]{"YES", "NO"};
    private OwnerUDB owner;
    private SchemaUDB schema;
    private String usingTypeID;
    private String size;
    private int precision;
    private int scale;
    private boolean reference;
    private String ref2RefTypeCastFunction = "";
    private String refType2RefCastFunction = "";
    private String inlineLength = "";
    private String withFunctionAccess = "NO";

    public StructuredTypeProxyUDB(StructuredType structuredType, StorageDesign storageDesign) {
        super(structuredType, storageDesign);
    }

    public StructuredTypeProxyUDB(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getInlineLength() {
        return this.inlineLength;
    }

    public void setInlineLength(String string) {
        this.inlineLength = string;
    }

    public OwnerUDB getOwner() {
        if (this.schema != null) {
            return this.getSchema().getOwner();
        }
        return this.owner;
    }

    public void setOwner(OwnerUDB ownerUDB) {
        this.owner = ownerUDB;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
    }

    public String getRef2RefTypeCastFunction() {
        return this.ref2RefTypeCastFunction;
    }

    public void setRef2RefTypeCastFunction(String string) {
        this.ref2RefTypeCastFunction = string;
    }

    public String getRefType2RefCastFunction() {
        return this.refType2RefCastFunction;
    }

    public void setRefType2RefCastFunction(String string) {
        this.refType2RefCastFunction = string;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String string) {
        this.size = string;
    }

    public String getWithFunctionAccess() {
        return this.withFunctionAccess;
    }

    public void setWithFunctionAccess(String string) {
        this.withFunctionAccess = string;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogUDB structuredTypePropertyDialogUDB = new StructuredTypePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            structuredTypePropertyDialogUDB.show();
        }
    }

    @Override
    public DesignObject getType() {
        if (!"".equalsIgnoreCase(this.usingTypeID)) {
            return this.getDesign().getDesignObject(this.usingTypeID);
        }
        return null;
    }

    @Override
    public void setType(DesignObject designObject) {
        this.usingTypeID = designObject != null ? designObject.getObjectID() : "";
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    private String formatDataType() {
        if (this.getType() != null) {
            Object object;
            String string = "";
            int n = 0;
            int n2 = 0;
            String string2 = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                string = this.size;
                n = this.precision;
                n2 = this.scale;
                string2 = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                object = (DistinctType)this.getType();
                if (((DistinctType)object).getLogicalDataType() != null) {
                    string = ((DistinctType)object).getSize();
                    n = ((DistinctType)object).getPrecision();
                    n2 = ((DistinctType)object).getScale();
                    string2 = ((DistinctType)object).getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                string2 = this.reference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            object = new StringBuffer(string2);
            boolean bl = false;
            boolean bl2 = false;
            if (string != null && !string.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (string != null && !string.equals("")) {
                ((StringBuffer)object).append(string);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    @Override
    public void setReference(boolean bl) {
        this.reference = bl;
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    public void copyDataType(DataTypeObject dataTypeObject) {
        dataTypeObject.setType(this.getType());
        dataTypeObject.setSize(this.getSize());
        dataTypeObject.setPrecision(this.getPrecision());
        dataTypeObject.setScale(this.getScale());
        dataTypeObject.setReference(this.isReference());
    }

    public String getUsingTypeID() {
        return this.usingTypeID;
    }

    public void setUsingTypeID(String string) {
        this.usingTypeID = string;
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return this.getName();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        StructuredTypeProxyUDB structuredTypeProxyUDB = null;
        StructuredTypeProxy structuredTypeProxy = ((StorageDesignUDBv71)storageDesign).getStructuredTypeProxySet().getByName(this.getName());
        if (structuredTypeProxy != null && !this.isRawObject()) {
            structuredTypeProxyUDB = (StructuredTypeProxyUDB)structuredTypeProxy;
        }
        if (structuredTypeProxyUDB != null) {
            structuredTypeProxyUDB.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv71 schemaUDBv71 = (SchemaUDBv71)((StorageDesignUDBv71)storageDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schemaUDBv71 == null) {
                    SchemaUDBv71 schemaUDBv712 = (SchemaUDBv71)((StorageDesignUDBv71)storageDesign).getSchemaSet().createSchema();
                    schemaUDBv712.setName(this.getSchema().getName());
                    schemaUDBv712.setRawObject(true);
                    structuredTypeProxyUDB.setSchema(schemaUDBv712);
                } else {
                    structuredTypeProxyUDB.setSchema(schemaUDBv71);
                }
            }
            structuredTypeProxyUDB.setType(this.getType());
            structuredTypeProxyUDB.setRef2RefTypeCastFunction(this.getRef2RefTypeCastFunction());
            structuredTypeProxyUDB.setRefType2RefCastFunction(this.getRefType2RefCastFunction());
            structuredTypeProxyUDB.setInlineLength(this.getInlineLength());
            structuredTypeProxyUDB.setWithFunctionAccess(this.getWithFunctionAccess());
            structuredTypeProxyUDB.setComment(this.getComment());
            structuredTypeProxyUDB.setRawObject(false);
        }
    }

    @Override
    public StorageObject getSchemaOrUser() {
        return this.getSchema();
    }
}

