/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.udb.SSBIncompleteStructuredTypeUDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBMethodUDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBNoneTransferableFK_UDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBStructuredTypeUDB;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.udb.AliasSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.FKProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.InstanceSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupSetUDB;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.storage.distincttype.DistinctTypesDialogUDB;

public abstract class StorageDesignUDB
extends StorageDesign {
    private PropertyHolder propertyholder = null;
    private DistinctTypeSetUDB distinctTypeSet = null;
    private boolean dtDialogVisible = false;

    public StorageDesignUDB(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        super(relationalDesign, rDBMSSite, design);
    }

    @Override
    public abstract String getName();

    @Override
    public PropertyHolder getPropertyHolder() {
        return this.propertyholder;
    }

    public abstract NodeGroupSetUDB getNodeGroupSet();

    public abstract BufferPoolSetUDB getBufferPoolSet();

    public abstract DataBaseSetUDB getDataBaseSet();

    public abstract InstanceSetUDB getInstanceSet();

    public abstract AliasSetUDB getAliasSet();

    public abstract ContainerSetUDB getContainerSet();

    public abstract TableSpaceSetUDB getTableSpaceSet();

    public abstract OwnerSet getOwnerSet();

    public abstract UserGroupSetUDB getUserGroupSet();

    public abstract SchemaSetUDB getSchemaSet();

    public abstract TriggerSetUDB getTriggerSet();

    public abstract StoredProcedureSetUDB getStoredProcedureSet();

    public abstract PrivilegesSetUDB getPrivilegesSet();

    public abstract PermissionsSetUDB getPermissionsSet();

    public abstract void updateGeneralRule();

    public FKProxySetUDB getFKProxySet() {
        return null;
    }

    public DistinctTypeSetUDB getDistinctTypeSet() {
        if (this.distinctTypeSet == null) {
            this.distinctTypeSet = new DistinctTypeSetUDB();
            this.distinctTypeSet.setDesign(this.getDesign());
            this.distinctTypeSet.setStorageDesign(this);
        }
        return this.distinctTypeSet;
    }

    @Override
    public List getStorableSetsList() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getStructuredTypeProxySet());
        arrayList.add(this.getInstanceSet());
        arrayList.add(this.getDataBaseSet());
        arrayList.add(this.getBufferPoolSet());
        arrayList.add(this.getContainerSet());
        arrayList.add(this.getAliasSet());
        arrayList.add(this.getNodeGroupSet());
        arrayList.add(this.getTableSpaceSet());
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getOwnerSet());
        arrayList.add(this.getUserGroupSet());
        arrayList.add(this.getSchemaSet());
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getStoredProcedureSet());
        arrayList.add(this.getDistinctTypeSet());
        return arrayList;
    }

    @Override
    public List getAllSetsList() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getStructuredTypeProxySet());
        arrayList.add(this.getTypeElementProxySet());
        arrayList.add(this.getMethodProxySet());
        arrayList.add(this.getInstanceSet());
        arrayList.add(this.getDataBaseSet());
        arrayList.add(this.getBufferPoolSet());
        arrayList.add(this.getContainerSet());
        arrayList.add(this.getAliasSet());
        arrayList.add(this.getNodeGroupSet());
        arrayList.add(this.getTableSpaceSet());
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getFKProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getColumnProxySet());
        arrayList.add(this.getOwnerSet());
        arrayList.add(this.getUserGroupSet());
        arrayList.add(this.getSchemaSet());
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getStoredProcedureSet());
        arrayList.add(this.getDistinctTypeSet());
        arrayList.add(this.getPrivilegesSet());
        arrayList.add(this.getPermissionsSet());
        return arrayList;
    }

    @Override
    public StorageObjectSet getStorageObjectSetForType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("UDBOwner")) {
            return this.getOwnerSet();
        }
        if (string.equalsIgnoreCase("UserGroup")) {
            return this.getUserGroupSet();
        }
        if (string.equalsIgnoreCase("Instance")) {
            return this.getInstanceSet();
        }
        if (string.equalsIgnoreCase("Database")) {
            return this.getDataBaseSet();
        }
        if (string.equalsIgnoreCase("DB")) {
            return this.getDataBaseSet();
        }
        if (string.equalsIgnoreCase("Bufferpool")) {
            return this.getBufferPoolSet();
        }
        if (string.equalsIgnoreCase("Container")) {
            return this.getContainerSet();
        }
        if (string.equalsIgnoreCase("Alias")) {
            return this.getAliasSet();
        }
        if (string.equalsIgnoreCase("NodeGroup")) {
            return this.getNodeGroupSet();
        }
        if (string.equalsIgnoreCase("TableSpace")) {
            return this.getTableSpaceSet();
        }
        if (string.equalsIgnoreCase("Schema")) {
            return this.getSchemaSet();
        }
        if (string.equalsIgnoreCase("Trigger")) {
            return this.getTriggerSet();
        }
        if (string.equalsIgnoreCase("StProc") || string.equalsIgnoreCase("StoredProcedure")) {
            return this.getStoredProcedureSet();
        }
        if (string.equalsIgnoreCase("DistinctType")) {
            return this.getDistinctTypeSet();
        }
        if (string.equalsIgnoreCase("Privileges")) {
            return this.getPrivilegesSet();
        }
        if (string.equalsIgnoreCase("Permissions")) {
            return this.getPermissionsSet();
        }
        return null;
    }

    @Override
    public boolean hasDistinctTypes() {
        return true;
    }

    @Override
    public void showDistinctTypes() {
        if (!this.dtDialogVisible) {
            DistinctTypesDialogUDB distinctTypesDialogUDB = new DistinctTypesDialogUDB(this.getDesign().getAppView(), this);
            distinctTypesDialogUDB.initProperties();
            distinctTypesDialogUDB.setVisible(true);
        }
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean bl) {
        this.dtDialogVisible = bl;
    }

    @Override
    public Iterator ddlIncompleteTypeObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjectsNoSort(arrayList, this.getStructuredTypesOrderedByParent());
        return arrayList.iterator();
    }

    @Override
    public Iterator ddlTypeObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjectsNoSort(arrayList, this.getStructuredTypesOrderedByParent());
        this.addDDLStorageObjects(arrayList, this.getMethodProxySet());
        return arrayList.iterator();
    }

    @Override
    protected DDLGenerator createDDLIncompleteTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBIncompleteStructuredTypeUDB());
        return dDLGeneratorSpecific;
    }

    @Override
    protected DDLGenerator createDDLTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBStructuredTypeUDB());
        dDLGeneratorSpecific.append(new SSBMethodUDB());
        return dDLGeneratorSpecific;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getFKProxySet());
        arrayList.add(this.getDataBaseSet());
        return arrayList;
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBNoneTransferableFK_UDB(this));
        return dDLGeneratorSpecific;
    }

    @Override
    public List getUniqueList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getFKProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getFKProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> list = super.createDDLSelectionSetsList();
        list.add(this.getDataBaseSet());
        list.add(this.getTableSpaceSet());
        list.add(this.getBufferPoolSet());
        list.add(this.getBufferPoolSet());
        list.add(this.getNodeGroupSet());
        list.add(this.getSchemaSet());
        list.add(this.getAliasSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getStructuredTypeProxySet());
        list.add(this.getTableProxySet());
        list.add(this.getTableViewProxySet());
        return list;
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getOwnerSet().sort();
        this.getUserGroupSet().sort();
        this.getSchemaSet().sort();
        this.getPrivilegesSet().sort();
        this.getAliasSet().sort();
        this.getBufferPoolSet().sort();
        this.getDistinctTypeSet().sort();
        this.getDataBaseSet().sort();
        this.getTableSpaceSet().sort();
        this.getInstanceSet().sort();
        this.getContainerSet().sort();
        this.getNodeGroupSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getSchemaSet();
    }
}

