/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;

public abstract class SequenceUDB
extends AbstractStorageObjectDB2 {
    protected Owner owner;
    protected SchemaUDB schema;
    protected String datatype = DATA_TYPES[0];
    protected int startWith = 1;
    protected int incrementBy = 1;
    protected String maxValue = "NO";
    protected String minValue = "NO";
    protected String cycle = YES_NO_STATES[1];
    protected int cache = 20;
    protected String order = YES_NO_STATES[1];
    protected static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String[] DATA_TYPES = new String[]{"INTEGER", "SMALLINT", "DECIMAL"};
    private static Set dataTypeSet = null;
    public static final String TYPE_NAME = "Sequence";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(SequenceUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public static String[] getDataTypes() {
        return DATA_TYPES;
    }

    protected boolean checkDataTypes(String string) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(SequenceUDB.getDataTypes()));
        }
        return dataTypeSet.contains(string);
    }

    public int getCache() {
        return this.cache;
    }

    public void setCache(int n) {
        if (n != 1) {
            this.cache = n;
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public void setCycle(String string) {
        if (this.checkYesNo(string)) {
            this.cycle = string;
        }
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String string) {
        if (this.checkDataTypes(string)) {
            this.datatype = string;
            this.fireDataFieldChange();
        }
    }

    public int getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(int n) {
        if (n >= 1) {
            this.incrementBy = n;
        }
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String string) {
        this.maxValue = string;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String string) {
        this.minValue = string;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String string) {
        if (this.checkYesNo(string)) {
            this.order = string;
            this.fireDataFieldChange();
        }
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public int getStartWith() {
        return this.startWith;
    }

    public void setStartWith(int n) {
        this.startWith = n;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        this.schema = schemaUDB;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getSchema() != null) {
            string = this.getSchema().getName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }
}

