/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;

public class PrivilegesUDB
extends StorageObject {
    protected SchemaUDB schema = null;
    protected OwnerUDB user = null;
    protected UserGroupUDB group = null;
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"ALTERIN", "CREATEIN", "DROPIN"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Privileges";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Priv";
    }

    private void addSystemPrivileges(String string) {
        if (!this.getSystemPrivilegesSet().contains(string)) {
            this.getSystemPrivilegesSet().add(string);
        }
    }

    private void recreateSystemPrivilegesSet(String string) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkPrivileges(string2)) continue;
            this.getSystemPrivilegesSet().add(string2);
        }
    }

    public void setSystemPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else if (this.checkPrivileges(string)) {
            this.addSystemPrivileges(string);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String string) {
        return PRIVILEGESLIST.contains(string);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(PrivilegesUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schemaUDB) {
        if (this.schema != schemaUDB) {
            this.schema = schemaUDB;
            this.fireDataFieldChange();
        }
    }

    public OwnerUDB getUser() {
        return this.user;
    }

    public void setUser(OwnerUDB ownerUDB) {
        if (this.user != ownerUDB) {
            this.user = ownerUDB;
            this.setPAC_Element(ownerUDB);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserGroupUDB getGroup() {
        return this.group;
    }

    public void setGroup(UserGroupUDB userGroupUDB) {
        if (this.group != userGroupUDB) {
            this.group = userGroupUDB;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        PrivilegesUDB privilegesUDB = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDB)storageDesign).getPrivilegesSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                privilegesUDB = (PrivilegesUDB)storageObject;
            }
        } else {
            privilegesUDB = ((StorageDesignUDB)storageDesign).getPrivilegesSet().createPriv();
        }
        if (privilegesUDB != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            privilegesUDB.setName(this.getName());
            privilegesUDB.setSchema(this.getSchema());
            if (this.getUser() != null) {
                storageObject3 = (OwnerUDB)((StorageDesignUDB)storageDesign).getOwnerSet().getByName(this.getUser().getName());
                if (storageObject3 == null) {
                    storageObject2 = (OwnerUDB)((StorageDesignUDB)storageDesign).getOwnerSet().createElement(null);
                    storageObject2.setName(this.getUser().getName());
                    storageObject2.setRawObject(true);
                    privilegesUDB.setUser((OwnerUDB)storageObject2);
                } else {
                    privilegesUDB.setUser((OwnerUDB)storageObject3);
                }
            }
            if (this.getGroup() != null) {
                storageObject3 = (UserGroupUDB)((StorageDesignUDB)storageDesign).getUserGroupSet().getByName(this.getGroup().getName());
                if (storageObject3 == null) {
                    storageObject2 = ((StorageDesignUDB)storageDesign).getUserGroupSet().createUserGroup();
                    storageObject2.setName(this.getGroup().getName());
                    storageObject2.setRawObject(true);
                    privilegesUDB.setGroup((UserGroupUDB)storageObject2);
                } else {
                    privilegesUDB.setGroup((UserGroupUDB)storageObject3);
                }
            }
            privilegesUDB.setGrantOption(this.getGrantOption());
            privilegesUDB.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            privilegesUDB.setRawObject(false);
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

