/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.editor.storage.udb.OwnerPropertyDialogUDB;

public class OwnerUDB
extends Owner {
    @Override
    public String getIDPrefix() {
        return "Owner";
    }

    @Override
    public String getObjectTypeName() {
        return "UDBOwner";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            OwnerPropertyDialogUDB ownerPropertyDialogUDB = new OwnerPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            ownerPropertyDialogUDB.show();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        OwnerUDB ownerUDB = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv71)storageDesign).getOwnerSetUDB().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                ownerUDB = (OwnerUDB)storageObject;
            }
        } else {
            ownerUDB = (OwnerUDB)((StorageDesignUDBv71)storageDesign).getOwnerSetUDB().createElement(null);
        }
        if (ownerUDB != null) {
            ownerUDB.setName(this.getName());
            ownerUDB.setComment(this.getComment());
            ownerUDB.setRawObject(false);
        }
    }

    private List getPermissions() {
        ArrayList<PermissionsUDB> arrayList = new ArrayList<PermissionsUDB>();
        Iterator iterator = ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != this) continue;
            arrayList.add(permissionsUDB);
        }
        return arrayList;
    }

    @Override
    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    private List getDBPrivileges() {
        ArrayList<PrivilegesUDB> arrayList = new ArrayList<PrivilegesUDB>();
        Iterator iterator = ((StorageDesignUDB)this.getStorageDesign()).getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            PrivilegesUDB privilegesUDB = (PrivilegesUDB)iterator.next();
            if (privilegesUDB.getUser() != this) continue;
            arrayList.add(privilegesUDB);
        }
        return arrayList;
    }

    @Override
    public List getSortedByID_DBPrivileges() {
        List list = this.getDBPrivileges();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public PermissionsUDB createPermissionUDB() {
        PermissionsUDB permissionsUDB = ((StorageDesignUDB)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsUDB.setUser(this);
        return permissionsUDB;
    }

    public PrivilegesUDB createDBPrivilegeUDB() {
        PrivilegesUDB privilegesUDB = ((StorageDesignUDB)this.getStorageDesign()).getPrivilegesSet().createPriv();
        privilegesUDB.setUser(this);
        return privilegesUDB;
    }
}

