/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class IndexProxySetUDB
extends IndexProxySet
implements ObjectListener {
    public IndexProxySetUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (index.isPK() || index.isUnique()) continue;
            this.add(index);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isAdded()) {
            Index index = (Index)modelObjectSetEvent.getAffected();
            index.addObjectListener(this);
            if (!index.isPK() && !index.isUnique()) {
                this.add(index);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved()) {
            Index index = (Index)modelObjectSetEvent.getAffected();
            index.removeObjectListener(this);
            if (this.containsId(index.getObjectID())) {
                this.remove((Index)modelObjectSetEvent.getAffected());
                this.fireUpdate();
            }
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (designObject instanceof Index) {
            Index index = (Index)designObject;
            if (objectChangeEvent == ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE || objectChangeEvent == ObjectChangeEvent.KEY_CHANGED_TO_PK) {
                if (index.isPK() || index.isUnique()) {
                    this.remove(index);
                }
            } else if (!(objectChangeEvent != ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE && objectChangeEvent != ObjectChangeEvent.KEY_CHANGED_NO_PK || index.isPK() || index.isUnique())) {
                this.add(index);
            }
        }
    }
}

