/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.FKPropertyDialogUDB;

public class FKProxyUDB
extends IndexProxy
implements StorageObjectListener {
    private static final String[] ON_DELETE = new String[]{"NO ACTION", "RESTRICT", "CASCADE", "SET NULL"};
    private static final String[] ON_UPDATE = new String[]{"NO ACTION", "RESTRICT"};
    private static List onDeleteList = Arrays.asList(ON_DELETE);
    private static List onUpdateList = Arrays.asList(ON_UPDATE);
    private static Set onDeleteSet = null;
    private static Set onUpdateSet = null;
    private String onDelete = ON_DELETE[0];
    private String onUpdate = ON_UPDATE[0];
    public static final String TYPE_NAME = "FKey";

    public FKProxyUDB(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyUDB(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public Table getFKTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getColumns() {
        return this.getColumns(null);
    }

    public String getColumns(StorageDesign storageDesign) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            String string = columnProxyArray[i].getName();
            if (storageDesign != null) {
                string = storageDesign.getFormatedName(string);
            }
            stringBuffer.append("     ").append(string);
        }
        return stringBuffer.toString();
    }

    public String getReferenceTable() {
        TableProxyUDB tableProxyUDB = (TableProxyUDB)this.getStorageDesign().getTableProxySet().getProxy(this.getFKTable().getObjectID());
        return tableProxyUDB.getLongName();
    }

    public String getReferenceColumns() {
        return this.getReferenceColumns(null);
    }

    public String getReferenceColumns(StorageDesign storageDesign) {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columnArray = (Column[])index.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnArray.length; ++i) {
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            String string = columnArray[i].getName();
            if (storageDesign != null) {
                string = storageDesign.getFormatedName(string);
            }
            stringBuffer.append("     ").append(string);
        }
        return stringBuffer.toString();
    }

    public Column[] getRefColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])index.getElements();
    }

    public static String[] getOnDeleteChoices() {
        return ON_DELETE;
    }

    public static String[] getOnUpdateChoices() {
        return ON_UPDATE;
    }

    protected boolean checkOnDelete(String string) {
        if (onDeleteSet == null) {
            onDeleteSet = new HashSet();
            onDeleteSet.addAll(Arrays.asList(FKProxyUDB.getOnDeleteChoices()));
        }
        return onDeleteSet.contains(string);
    }

    public void setOnDelete(String string) {
        if (this.checkOnDelete(string)) {
            this.onDelete = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    protected boolean checkOnUpdate(String string) {
        if (onUpdateSet == null) {
            onUpdateSet = new HashSet();
            onUpdateSet.addAll(Arrays.asList(FKProxyUDB.getOnUpdateChoices()));
        }
        return onUpdateSet.contains(string);
    }

    public void setOnUpdate(String string) {
        if (this.checkOnUpdate(string)) {
            this.onUpdate = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public static List getOnUpdateValues() {
        return onUpdateList;
    }

    public static List getOnDeleteValues() {
        return onDeleteList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogUDB fKPropertyDialogUDB = new FKPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            fKPropertyDialogUDB.show();
        }
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.isFK() && index.getFKAssociation() != null ? index.getFKAssociation().getName() : index.getName();
        string = this.applyNameSubstitution(string);
        return string;
    }
}

