/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.InstanceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.DatabasePropertyDialogUDB;

public class DataBaseUDB
extends StorageObject {
    public static final String COMPATIBILITY = "COMPATIBILITY";
    public static final String SYSTEM = "SYSTEM";
    public static final String IDENTITY = "IDENTITY";
    public static final int MAXIMUM_COMMENT_LENGTH = 30;
    protected static String[] availableCollatingSequences = new String[]{"", "COMPATIBILITY", "SYSTEM", "IDENTITY"};
    private String onPath = "";
    private String alias = "";
    private String codeset = "";
    private String territory = "";
    private String collatingSequence = "";
    private int segmentNumber = 0;
    private int defaultExtentSize = 0;
    private InstanceUDB instance = null;
    private TableSpaceUDB catalogTableSpace = null;
    private TableSpaceUDB userTableSpace = null;
    private TableSpaceUDB temporaryTableSpace = null;
    public static final String TYPE_NAME = "DB";
    public static final String OLD_TYPE_NAME = "Database";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setOnPath(String string) {
        this.onPath = string;
        this.fireDataFieldChange();
    }

    public String getOnPath() {
        return this.onPath;
    }

    public void setAlias(String string) {
        this.alias = string;
        this.fireDataFieldChange();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setCodeSet(String string) {
        this.codeset = string;
        this.fireDataFieldChange();
    }

    public String getCodeSet() {
        return this.codeset;
    }

    public void setTerritory(String string) {
        this.territory = string;
        this.fireDataFieldChange();
    }

    public String getTerritory() {
        return this.territory;
    }

    public static String[] getAvailableCollatingSequences() {
        return availableCollatingSequences;
    }

    public void setCollatingSequence(String string) {
        this.collatingSequence = string;
        this.fireDataFieldChange();
    }

    public String getCollatingSequence() {
        return this.collatingSequence;
    }

    public void setSegmentNumber(int n) {
        this.segmentNumber = n;
        this.fireDataFieldChange();
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setDefaultExtentSize(int n) {
        this.defaultExtentSize = n;
        this.fireDataFieldChange();
    }

    public int getDefaultExtentSize() {
        return this.defaultExtentSize;
    }

    @Override
    public void setCommentInRDBMS(String string) {
        super.setCommentInRDBMS(string);
        this.fireDataFieldChange();
    }

    public boolean checkComment(String string) {
        return string.length() <= 30;
    }

    public void setInstance(InstanceUDB instanceUDB) {
        this.instance = instanceUDB;
        this.fireDataFieldChange();
    }

    public InstanceUDB getInstance() {
        return this.instance;
    }

    public void setCatalogTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.catalogTableSpace = tableSpaceUDB;
        if (tableSpaceUDB != null) {
            tableSpaceUDB.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getCatalogTableSpace() {
        return this.catalogTableSpace;
    }

    public void setUserTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.userTableSpace = tableSpaceUDB;
        if (tableSpaceUDB != null) {
            tableSpaceUDB.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getUserTableSpace() {
        return this.userTableSpace;
    }

    public void setTemporaryTableSpace(TableSpaceUDB tableSpaceUDB) {
        this.temporaryTableSpace = tableSpaceUDB;
        if (tableSpaceUDB != null) {
            tableSpaceUDB.setDBDefOnly(true);
        }
        this.fireDataFieldChange();
    }

    public TableSpaceUDB getTemporaryTableSpace() {
        return this.temporaryTableSpace;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DatabasePropertyDialogUDB databasePropertyDialogUDB = new DatabasePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            databasePropertyDialogUDB.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }
}

